/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIn;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;
import org.mule.service.soap.client.TestSoapClient;
import org.mule.service.soap.metadata.AbstractMetadataTestCase;

@Feature(value="WSC Extension")
@Story(value="Metadata")
public class HeadersMetadataTestCase
extends AbstractMetadataTestCase {
    @Test
    @Description(value="Checks the input Soap Headers metadata for an operation with headers")
    public void operationWithInputHeadersMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("echoWithHeaders");
        ObjectType headers = this.toObjectType(result.getHeadersType());
        Collection fields = headers.getFields();
        Assert.assertThat((Object)fields, (Matcher)Matchers.hasSize((int)2));
        fields.forEach(field -> {
            Collection headerFields = ((ObjectType)field.getValue()).getFields();
            Assert.assertThat((Object)headerFields, (Matcher)Matchers.hasSize((int)1));
            MetadataType headerField = ((ObjectFieldType)headerFields.iterator().next()).getValue();
            Assert.assertThat((Object)headerField, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        });
    }

    @Test
    @Description(value="Checks the input Soap Headers metadata for an operation without headers")
    public void operationWithoutInputHeadersMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("echo");
        Assert.assertThat((Object)result.getHeadersType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    @Description(value="Checks the metadata for a Header that is defined in another message that is not the main operation message")
    public void operationWithCommonHeaderDefinedInDifferentMessageMetadata() throws MetadataResolvingException {
        URL humanWsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/human.wsdl");
        SoapClientConfiguration configuration = SoapClientConfiguration.builder().withDispatcher((MessageDispatcher)this.dispatcher).withAddress("address.com").withVersion(this.soapVersion).withWsdlLocation(humanWsdl.getPath()).withService("Human_ResourcesService").withPort("Human_Resources").build();
        TestSoapClient humanWsdlClient = new TestSoapClient(configuration);
        SoapOperationMetadata result = humanWsdlClient.getMetadataResolver().getInputMetadata("Get_Employee");
        ObjectType headers = this.toObjectType(result.getHeadersType());
        Assert.assertThat((Object)headers.getFields(), (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType header = (ObjectFieldType)headers.getFields().iterator().next();
        Assert.assertThat((Object)header.getKey().getName().getLocalPart(), (Matcher)Matchers.is((Object)"header"));
        String headerTypeId = ((TypeIdAnnotation)header.getValue().getAnnotation(TypeIdAnnotation.class).get()).getValue();
        Assert.assertThat((Object)headerTypeId, (Matcher)Matchers.is((Object)"{urn:com.workday/bsvc}Workday_Common_Header"));
    }

    @Test
    @Description(value="Checks the Output Attributes Metadata for an operation with output soap headers")
    public void operationWithOutputSoapHeadersMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getOutputMetadata("echoWithHeaders");
        ObjectType outputHeaders = this.toObjectType(result.getHeadersType());
        Assert.assertThat((Object)outputHeaders.getFields(), (Matcher)Matchers.hasSize((int)2));
        outputHeaders.getFields().forEach(e -> {
            Assert.assertThat((Object)e.getKey().getName().getLocalPart(), (Matcher)IsIn.isIn((Object[])new String[]{"headerOut", "headerInOut"}));
            MetadataType value = ((ObjectFieldType)this.toObjectType(e.getValue()).getFields().iterator().next()).getValue();
            Assert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        });
    }

    @Test
    @Description(value="Checks the Output Attributes Metadata for an operation without output soap headers")
    public void operationWithoutOutputSoapHeadersMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getOutputMetadata("echo");
        MetadataType outputHeaders = result.getHeadersType();
        Assert.assertThat((Object)outputHeaders, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    @Description(value="Checks the metadata for an operation that is ONE WAY")
    public void oneWayOperationMetadata() throws MetadataResolvingException {
        SoapOperationMetadata input = this.resolver.getInputMetadata("oneWay");
        SoapOperationMetadata output = this.resolver.getOutputMetadata("oneWay");
        Assert.assertThat((Object)input.getHeadersType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
        Assert.assertThat((Object)output.getHeadersType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }
}

