/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime;

import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.message.ImmutableSoapRequest;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.AbstractSoapServiceTestCase;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.client.TestSoapClient;

@Feature(value="WSC Extension")
@Story(value="Operation Execution")
public class OperationExecutionTestCase
extends AbstractSoapServiceTestCase {
    @Test
    @Description(value="Consumes an operation that expects a simple type and returns a simple type")
    public void simpleOperation() throws Exception {
        this.testSimpleOperation(this.client);
    }

    @Test
    @Description(value="Consumes an operation using a connection that uses a local .wsdl file")
    public void echoWithLocalWsdl() throws Exception {
        URL wsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        TestSoapClient localWsdlClient = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withWsdlLocation(wsdl.getPath()).withDispatcher((MessageDispatcher)this.dispatcher).withVersion(this.soapVersion).build());
        this.testSimpleOperation(localWsdlClient);
    }

    @Test
    @Description(value="Consumes an operation that expects an input and a set of headers and returns a simple type and a set of headers")
    public void simpleOperationWithHeaders() throws Exception {
        ImmutableMap headers = ImmutableMap.builder().put((Object)"headerIn", (Object)this.testValues.getHeaderIn()).put((Object)"headerInOut", (Object)this.testValues.getHeaderInOutRequest()).build();
        ImmutableSoapRequest req = SoapRequest.builder().content(this.testValues.getEchoWithHeadersRequest()).operation("echoWithHeaders").soapHeaders((Map)headers).contentType(MediaType.APPLICATION_XML).build();
        SoapResponse response = this.client.consume((SoapRequest)req);
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerOut"), this.testValues.getHeaderOut());
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerInOut"), this.testValues.getHeaderInOutResponse());
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoWithHeadersResponse(), response.getContent());
    }

    @Test
    @Description(value="Consumes an operation that expects 2 parameters (a simple one and a complex one) and returns a complex type")
    public void complexTypeOperation() throws Exception {
        ImmutableSoapRequest req = SoapRequest.builder().content(this.testValues.getEchoAccountRequest()).operation("echoAccount").build();
        SoapResponse response = this.client.consume((SoapRequest)req);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoAccountResponse(), response.getContent());
    }

    @Test
    @Description(value="Consumes an operation that expects no parameters and returns a simple type")
    public void noParamsOperation() throws Exception {
        ImmutableSoapRequest req = SoapRequest.builder().content(this.testValues.getNoParamsRequest()).operation("noParams").build();
        this.testNoParams((SoapRequest)req);
    }

    @Test
    @Description(value="Consumes an operation that expects no parameters and returns a simple type")
    public void large() throws Exception {
        ImmutableSoapRequest req = SoapRequest.builder().operation("large").build();
        InputStream response = this.client.consume((SoapRequest)req).getContent();
        String largeContent = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource("large.json").openStream());
        SoapTestUtils.assertSimilarXml(this.testValues.buildXml("largeResponse", "<largeResponse>" + largeContent + "</largeResponse>"), response);
    }

    @Test
    @Description(value="Consumes an operation that expects no parameters auto-generating the request and returns a simple type")
    public void noParamsOperationWithoutXmlPayload() throws Exception {
        this.testNoParams(SoapRequest.empty((String)"noParams"));
    }

    @Test
    @Description(value="Consumes an operation and checks the output transport headers")
    public void transportHeaders() throws Exception {
        ImmutableSoapRequest request = SoapRequest.builder().content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = this.client.consume((SoapRequest)request);
        Map transportHeaders = response.getTransportHeaders();
        MatcherAssert.assertThat(transportHeaders.entrySet(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    @Description(value="Consumes an operation that is one way, without response")
    public void oneWayOperation() throws IOException {
        ImmutableSoapRequest req = SoapRequest.builder().operation("oneWay").content(this.testValues.getOneWayRequest()).build();
        SoapResponse response = this.client.consume((SoapRequest)req);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getContent()), (Matcher)Is.is((Object)""));
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    private void testSimpleOperation(SoapClient client) throws Exception {
        ImmutableSoapRequest request = SoapRequest.builder().content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = client.consume((SoapRequest)request);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoResponse(), response.getContent());
    }

    private void testNoParams(SoapRequest request) throws Exception {
        SoapResponse response = this.client.consume(request);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getNoParamsResponse(), response.getContent());
    }
}

