/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.exception.SoapFaultException;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.service.soap.AbstractSoapServiceTestCase;

@Feature(value="WSC Extension")
@Stories(value={@Story(value="Operation Execution"), @Story(value="Soap Fault")})
public class SoapFaultTestCase
extends AbstractSoapServiceTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    @Description(value="Consumes an operation that throws a SOAP Fault and expects a Soap Fault Exception")
    public void failOperation() throws Exception {
        try {
            this.client.consume((SoapRequest)SoapRequest.builder().content(this.testValues.getFailRequest()).operation("fail").build());
        }
        catch (SoapFaultException e) {
            MatcherAssert.assertThat((Object)e.getFaultCode().getLocalPart(), (Matcher)Matchers.isOneOf((Object[])new String[]{"Server", "Receiver"}));
            MatcherAssert.assertThat((Object)e.getReason(), (Matcher)Is.is((Object)"Fail Message"));
            MatcherAssert.assertThat((Object)e.getDetail(), (Matcher)StringContains.containsString((String)"EchoException"));
            MatcherAssert.assertThat((Object)e.getDetail(), (Matcher)StringContains.containsString((String)"Fail Message"));
        }
    }

    @Test
    @Description(value="Consumes an operation that does not exist and throws a SOAP Fault because of it and asserts the thrown exception")
    public void noExistentOperation() throws Exception {
        this.expectedException.expect(BadRequestException.class);
        this.expectedException.expectMessage("The provided [FAIL] does not exist in the WSDL file");
        this.client.consume((SoapRequest)SoapRequest.builder().content(this.testValues.buildXml("FAIL", "")).operation("FAIL").build());
    }

    @Test
    @Description(value="Consumes an operation with a body that is not a valid XML")
    public void echoBodyIsNotValidXml() throws Exception {
        this.expectedException.expect(BadRequestException.class);
        this.expectedException.expectMessage("Error consuming the operation [echo], the request body is not a valid XML");
        this.client.consume((SoapRequest)SoapRequest.builder().operation("echo").content("Invalid Test Payload: this is not an XML").build());
    }
}

