/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;
import org.mule.service.soap.metadata.AbstractMetadataTestCase;

@Feature(value="WSC Extension")
@Story(value="Metadata")
public class AttachmentMetadataTestCase
extends AbstractMetadataTestCase {
    @Test
    @Description(value="Checks the Input Metadata of an operation with required input attachments")
    public void operationWithInputAttachmentMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("uploadAttachment");
        ObjectType attachments = this.toObjectType(result.getAttachmentsType());
        Collection attachmentFields = attachments.getFields();
        MatcherAssert.assertThat((Object)attachmentFields, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ObjectFieldType)attachmentFields.iterator().next()).getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"attachment"));
    }

    @Test
    @Description(value="Checks the Input Metadata of an operation without attachments")
    public void operationWithoutInputAttachmentsMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("echo");
        MatcherAssert.assertThat((Object)result.getAttachmentsType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    @Description(value="Checks the Output Metadata of an operation that contains output attachments")
    public void operationWithOutputAttachmentsMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getOutputMetadata("downloadAttachment");
        ObjectType objectType = this.toObjectType(result.getAttachmentsType());
        MatcherAssert.assertThat((Object)objectType.getFields(), (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType attachment = (ObjectFieldType)objectType.getFields().iterator().next();
        MatcherAssert.assertThat((Object)attachment.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"attachment"));
        MatcherAssert.assertThat((Object)attachment.getValue(), (Matcher)Is.is((Matcher)Matchers.instanceOf(BinaryType.class)));
        MatcherAssert.assertThat((Object)result.getBodyType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    @Description(value="Checks the metadata for an operation that is ONE WAY")
    public void oneWayOperationMetadata() throws MetadataResolvingException {
        SoapOperationMetadata input = this.resolver.getInputMetadata("oneWay");
        SoapOperationMetadata output = this.resolver.getOutputMetadata("oneWay");
        Assert.assertThat((Object)input.getAttachmentsType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
        Assert.assertThat((Object)output.getAttachmentsType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }
}

