/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.soap.generator;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.mule.service.soap.client.SoapCxfClient.MULE_ATTACHMENTS_KEY;

import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.generator.attachment.SoapAttachmentResponseEnricher;
import org.mule.wsdl.parser.model.operation.OperationModel;

import java.util.Map;

import org.apache.cxf.message.Exchange;

public class SoapAttachmentsResponseEnricherTestCase extends ResponseEnricherTestCase {

  private static final String RESPONSE =
      "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.service.mule.org/\">"
          + "<attachment>U29tZSBDb250ZW50</attachment>"
          + "</con:downloadAttachmentResponse>";

  @Override
  protected String getResponse() {
    return RESPONSE;
  }

  @Override
  protected AttachmentResponseEnricher getEnricher(XmlTypeLoader loader, Map<String, OperationModel> ops) {
    return new SoapAttachmentResponseEnricher(loader, ops);
  }

  @Override
  protected void assertAttachment(Exchange exchange) {
    Map<String, SoapAttachment> attachments = (Map<String, SoapAttachment>) exchange.get(MULE_ATTACHMENTS_KEY);
    assertThat(attachments.entrySet(), hasSize(1));
    String value = IOUtils.toString(attachments.get("attachment").getContent());
    assertThat(value, is("Some Content"));
  }
}
