/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.unit;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStream;
import org.mule.runtime.extension.api.soap.SoapOutputPayload;

public class SoapOutputPayloadTestCase {
    @Test
    public void toStringOnlyBody() {
        TypedValue body = new TypedValue((Object)new ByteArrayInputStream("<xml>ABC</xml>".getBytes(StandardCharsets.UTF_8)), null);
        String result = new SoapOutputPayload(body, Collections.emptyMap(), Collections.emptyMap()).toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)"{\nbody:<xml>ABC</xml>,\nheaders: [],\nattachments: []\n}"));
    }

    @Test
    public void toStringFullPayload() {
        TypedValue body = TypedValue.of((Object)new ByteArrayInputStream("<xml>ABC</xml>".getBytes(StandardCharsets.UTF_8)));
        ImmutableMap hs = ImmutableMap.of((Object)"header1", (Object)TypedValue.of((Object)"<header1>content</header1>"), (Object)"header2", (Object)TypedValue.of((Object)"<header2>content</header2>"));
        ImmutableMap as = ImmutableMap.of((Object)"attachment1", (Object)TypedValue.of(null), (Object)"attachment2", (Object)TypedValue.of(null));
        String result = new SoapOutputPayload(body, (Map)as, (Map)hs).toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)"{\nbody:<xml>ABC</xml>,\nheaders: [\"<header1>content</header1>\",\n  \"<header2>content</header2>\"],\nattachments: [attachment1, attachment2]\n}"));
    }

    @Test
    public void withCursorProvier() {
        CursorStreamProvider mock = (CursorStreamProvider)Mockito.mock(CursorStreamProvider.class);
        Mockito.when((Object)mock.openCursor()).thenReturn((Object)new ByteArrayCursorStream(mock, "<xml>ABC</xml>".getBytes(StandardCharsets.UTF_8)));
        TypedValue body = TypedValue.of((Object)mock);
        ImmutableMap hs = ImmutableMap.of((Object)"header1", (Object)TypedValue.of((Object)"<header1>content</header1>"), (Object)"header2", (Object)TypedValue.of((Object)"<header2>content</header2>"));
        ImmutableMap as = ImmutableMap.of((Object)"attachment1", (Object)TypedValue.of(null), (Object)"attachment2", (Object)TypedValue.of(null));
        String result = new SoapOutputPayload(body, (Map)as, (Map)hs).toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)"{\nbody:<xml>ABC</xml>,\nheaders: [\"<header1>content</header1>\",\n  \"<header2>content</header2>\"],\nattachments: [attachment1, attachment2]\n}"));
    }
}

