/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.cxf.message.Attachment;
import org.apache.tika.io.NullInputStream;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.service.soap.client.CxfAttachmentsFactory;

public class CxfAttachmentsTestCase {
    @Test
    public void notMtom() {
        CxfAttachmentsFactory factory = new CxfAttachmentsFactory(false);
        MatcherAssert.assertThat((Object)factory.transformToCxfAttachments(this.buildAttachments()), (Matcher)Matchers.is(Collections.emptyMap()));
    }

    @Test
    public void MtomEnabled() {
        CxfAttachmentsFactory factory = new CxfAttachmentsFactory(true);
        Map attachments = factory.transformToCxfAttachments(this.buildAttachments());
        MatcherAssert.assertThat(attachments.keySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(attachments.keySet(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new AttachmentMatcher(attachments, "name1", MediaType.APPLICATION_JAVA), new AttachmentMatcher(attachments, "name2", MediaType.APPLICATION_XML), new AttachmentMatcher(attachments, "name3", MediaType.APPLICATION_JSON)}));
    }

    private Map<String, SoapAttachment> buildAttachments() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"name1", (Object)new SoapAttachment((InputStream)new NullInputStream(10L), MediaType.APPLICATION_JAVA));
        builder.put((Object)"name2", (Object)new SoapAttachment((InputStream)new NullInputStream(10L), MediaType.APPLICATION_XML));
        builder.put((Object)"name3", (Object)new SoapAttachment((InputStream)new NullInputStream(10L), MediaType.APPLICATION_JSON));
        return builder.build();
    }

    private class AttachmentMatcher
    extends BaseMatcher<String> {
        private String expectedName;
        private String expectedMediaType;
        private Map<String, Attachment> attachmentMap;

        public AttachmentMatcher(Map<String, Attachment> map, String expectedName, MediaType expectedMediaType) {
            this.expectedName = expectedName;
            this.expectedMediaType = expectedMediaType.toRfcString();
            this.attachmentMap = map;
        }

        public boolean matches(Object o) {
            String name = (String)o;
            if (!this.expectedName.equals(name)) {
                return false;
            }
            String actualMediaType = this.attachmentMap.get(name).getDataHandler().getContentType();
            if (!this.expectedMediaType.equals(actualMediaType)) {
                return false;
            }
            return this.attachmentMap.get(name).getHeader("Content-Disposition").contains("attachment");
        }

        public void describeTo(Description description) {
        }
    }
}

