/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime.attachments;

import io.qameta.allure.Description;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.message.ImmutableSoapRequest;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.AbstractSoapServiceTestCase;
import org.mule.service.soap.SoapTestUtils;

public class AttachmentsTestCase
extends AbstractSoapServiceTestCase {
    @Test
    @Description(value="Downloads an attachment from a mtom server")
    public void downloadAttachment() throws Exception {
        ImmutableSoapRequest req = SoapRequest.builder().content(this.testValues.getDownloadAttachmentRequest()).operation("downloadAttachment").build();
        SoapResponse response = this.client.consume((SoapRequest)req);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), response.getContent());
        Map attachments = response.getAttachments();
        Assert.assertThat(attachments.entrySet(), (Matcher)Matchers.hasSize((int)1));
        SoapAttachment attachment = (SoapAttachment)attachments.entrySet().iterator().next().getValue();
        Assert.assertThat((Object)IOUtils.toString((InputStream)attachment.getContent()), (Matcher)Matchers.containsString((String)"Simple Attachment Content"));
    }

    @Test
    @Description(value="Uploads an attachment to a mtom server")
    public void uploadAttachment() throws Exception {
        ImmutableSoapRequest request = SoapRequest.builder().attachment("attachment", new SoapAttachment((InputStream)new ByteArrayInputStream("Some Content".getBytes()), MediaType.HTML)).content(this.testValues.getUploadAttachmentRequest()).operation("uploadAttachment").build();
        SoapResponse response = this.client.consume((SoapRequest)request);
        SoapTestUtils.assertSimilarXml(this.testValues.getUploadAttachmentResponse(), response.getContent());
    }
}

