/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import io.qameta.allure.Description;
import java.io.InputStream;
import java.util.Map;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.generator.AbstractEnricherTestCase;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.generator.attachment.SoapAttachmentResponseEnricher;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.w3c.dom.Document;

public class SoapAttachmentsResponseEnricherTestCase
extends AbstractEnricherTestCase {
    private AttachmentResponseEnricher enricher;

    @Override
    @Before
    public void setup() {
        super.setup();
        Map ops = this.model.getService("TestService").getPort("TestPort").getOperationsMap();
        this.enricher = new SoapAttachmentResponseEnricher((TypeLoader)this.model.getLoader().getValue(), ops);
    }

    @Test
    @Description(value="Enrich a response that contains attachments encoded with windows-1252")
    public void enrichWindows1252EncodingAttachment() throws Exception {
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.service.mule.org/\"><attachment>QWxndW0gQ29udGX6ZG8gZW0gUG9ydHVndepzIHBhcmEgV2luZG93cw==</attachment></con:downloadAttachmentResponse>";
        ExchangeImpl exchange = new ExchangeImpl();
        Document doc = XmlTransformationUtils.stringToDocument((String)response);
        String result = this.enricher.enrich(doc, "downloadAttachment", (Exchange)exchange);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange, "Algum Conte\u00fado em Portugu\u00eas para Windows", "windows-1252");
    }

    @Test
    @Description(value="Enrich a response that contains attachments encoded with UTF-8")
    public void enrichUtf8EncodingAttachment() throws Exception {
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.service.mule.org/\"><attachment>U29tZSBDb250ZW50</attachment></con:downloadAttachmentResponse>";
        ExchangeImpl exchange = new ExchangeImpl();
        Document doc = XmlTransformationUtils.stringToDocument((String)response);
        Map ops = this.model.getService("TestService").getPort("TestPort").getOperationsMap();
        this.enricher = new SoapAttachmentResponseEnricher((TypeLoader)this.model.getLoader().getValue(), ops);
        String result = this.enricher.enrich(doc, "downloadAttachment", (Exchange)exchange);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange, "Some Content", "UTF-8");
    }

    private void assertAttachment(Exchange exchange, String attachmentText, String attachmentEncoding) {
        Map attachments = (Map)exchange.get((Object)"mule.soap.attachments");
        MatcherAssert.assertThat(attachments.entrySet(), (Matcher)Matchers.hasSize((int)1));
        String value = IOUtils.toString((InputStream)((SoapAttachment)attachments.get("attachment")).getContent(), (String)attachmentEncoding);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)attachmentText));
    }
}

