/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.generator.AbstractEnricherTestCase;
import org.mule.service.soap.generator.EmptyRequestGenerator;

@Feature(value="WSC Extension")
@Story(value="Request Generation")
public class EmptyRequestGeneratorTestCase
extends AbstractEnricherTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private EmptyRequestGenerator generator;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.generator = new EmptyRequestGenerator(this.model.getService("TestService").getPort("TestPort"), (TypeLoader)this.model.getLoader().getValue());
    }

    @Test
    @Description(value="Checks the generation of a body request for an operation that don't require any parameters")
    public void noParams() throws Exception {
        String request = this.generator.generateRequest("noParams");
        SoapTestUtils.assertSimilarXml(request, this.testValues.getNoParamsRequest());
    }

    @Test
    @Description(value="Checks that the generation of a body request for an operation that require parameters fails")
    public void withParams() throws Exception {
        this.exception.expect(BadRequestException.class);
        this.exception.expectMessage("Cannot build default body request for operation [echo], the operation requires input parameters");
        this.generator.generateRequest("echo");
    }
}

