/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NameType$;
import org.mule.weave.v2.model.types.NamespaceType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.TypeType$;
import org.mule.weave.v2.model.types.UriType$;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Range;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spire.math.Number;

public final class StringCoercer$
implements ValueCoercer<StringValue> {
    public static StringCoercer$ MODULE$;

    static {
        new StringCoercer$();
    }

    @Override
    public StringValue coerce(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext ctx) {
        Type type;
        Type type2;
        Type type3;
        Type type4;
        Type type5;
        Type type6;
        Type type7;
        Type type8;
        Type type9;
        Type type10;
        Type type11;
        Type type12;
        Type type13;
        Type type14;
        Type type15;
        Type type16;
        Type type17;
        String string;
        Type type18;
        Type type19 = value.valueType(ctx);
        if (type19 != null && (type18 = type19).isInstanceOf(StringType$.MODULE$, ctx)) {
            string = (String)value.evaluate(ctx);
        } else if (type19 != null && (type17 = type19).isInstanceOf(DateTimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((ZonedDateTime)value.evaluate(ctx), targetType.schema(ctx), DateTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type19 != null && (type16 = type19).isInstanceOf(LocalDateTimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((LocalDateTime)value.evaluate(ctx), targetType.schema(ctx), LocalDateTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type19 != null && (type15 = type19).isInstanceOf(LocalTimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((LocalTime)value.evaluate(ctx), targetType.schema(ctx), LocalTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type19 != null && (type14 = type19).isInstanceOf(LocalDateType$.MODULE$, ctx)) {
            string = this.formatTemporal((LocalDate)value.evaluate(ctx), targetType.schema(ctx), LocalDateType$.MODULE$, locationCapable, value, ctx);
        } else if (type19 != null && (type13 = type19).isInstanceOf(TimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((OffsetTime)value.evaluate(ctx), targetType.schema(ctx), TimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type19 != null && (type12 = type19).isInstanceOf(PeriodType$.MODULE$, ctx)) {
            string = ((TemporalAmount)value.evaluate(ctx)).toString();
        } else if (type19 != null && (type11 = type19).isInstanceOf(TimeZoneType$.MODULE$, ctx)) {
            string = ((ZoneOffset)value.evaluate(ctx)).toString();
        } else if (type19 != null && (type10 = type19).isInstanceOf(NumberType$.MODULE$, ctx)) {
            string = this.formatNumber((Number)value.evaluate(ctx), targetType.schema(ctx), locationCapable, value, ctx);
        } else if (type19 != null && (type9 = type19).isInstanceOf(BooleanType$.MODULE$, ctx)) {
            string = ((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean(value.evaluate(ctx)))).toString();
        } else if (type19 != null && (type8 = type19).isInstanceOf(RangeType$.MODULE$, ctx)) {
            string = ((Range)value.evaluate(ctx)).mkString();
        } else if (type19 != null && (type7 = type19).isInstanceOf(UriType$.MODULE$, ctx)) {
            string = ((URI)value.evaluate(ctx)).toString();
        } else if (type19 != null && (type6 = type19).isInstanceOf(BinaryType$.MODULE$, ctx)) {
            string = new String((byte[])value.evaluate(ctx), (String)targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.encoding(ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Charset.defaultCharset().name()));
        } else if (type19 != null && (type5 = type19).isInstanceOf(NameType$.MODULE$, ctx)) {
            string = ((QualifiedName)value.evaluate(ctx)).name();
        } else if (type19 != null && (type4 = type19).isInstanceOf(TypeType$.MODULE$, ctx)) {
            string = ((Type)value.evaluate(ctx)).name();
        } else if (type19 != null && (type3 = type19).isInstanceOf(KeyType$.MODULE$, ctx)) {
            string = ((QualifiedName)value.evaluate(ctx)).name();
        } else if (type19 != null && (type2 = type19).isInstanceOf(RegexType$.MODULE$, ctx)) {
            string = ((Regex)value.evaluate(ctx)).toString();
        } else if (type19 != null && (type = type19).isInstanceOf(NamespaceType$.MODULE$, ctx)) {
            string = ((Namespace)value.evaluate(ctx)).uri();
        } else {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, value, ctx);
        }
        String result = string;
        return StringValue$.MODULE$.apply(result, locationCapable, targetType);
    }

    public String formatTemporal(TemporalAccessor temporal, Option<Schema> schema, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        Option formattedStringMaybe = schema.flatMap((Function1 & Serializable & scala.Serializable)schemaValue -> schemaValue.format(ctx).map((Function1 & Serializable & scala.Serializable)format -> this.doFormatTemporal(temporal, (Locale)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)localeString -> Locale.forLanguageTag(localeString)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Locale.getDefault()), (String)format, sourceType, locationCapable, value, ctx)));
        return (String)formattedStringMaybe.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultFormatTemporal(temporal));
    }

    public String doFormatTemporal(TemporalAccessor temporal, Locale locale, String format, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        String string;
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, locale);
            string = formatter.format(temporal);
        }
        catch (DateTimeException dte) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)dte.getMessage()), ctx);
        }
        catch (IllegalArgumentException iae) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)iae.getMessage()), ctx);
        }
        return string;
    }

    public String defaultFormatTemporal(TemporalAccessor temporal) {
        DateTimeFormatter dateTimeFormatter;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof ZonedDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        } else if (temporalAccessor instanceof LocalDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (temporalAccessor instanceof LocalTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (temporalAccessor instanceof LocalDate) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (temporalAccessor instanceof OffsetTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_TIME;
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return formatter.format(temporal);
    }

    public String formatNumber(Number n, Option<Schema> mayBeSchema, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        String string;
        Option<Schema> option = mayBeSchema;
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Schema schemaValue = schema;
            Option<String> option2 = schemaValue.format(ctx);
            if (option2 instanceof Some) {
                String string3;
                Some some2 = (Some)option2;
                String f = (String)some2.value();
                try {
                    DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)locale -> DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale))).getOrElse((Function0 & Serializable & scala.Serializable)() -> DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT)));
                    DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                    formatter.setRoundingMode(RoundingMode.HALF_UP);
                    formatter.setParseBigDecimal(true);
                    string3 = formatter.format(n.toBigDecimal().bigDecimal());
                }
                catch (IllegalArgumentException iae) {
                    throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), NumberType$.MODULE$, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)iae.getMessage()), ctx);
                }
                string2 = string3;
            } else {
                string2 = n.toString();
            }
            string = string2;
        } else {
            string = n.toString();
        }
        return string;
    }

    private StringCoercer$() {
        MODULE$ = this;
    }
}

