/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.module.csv.exception.CSVParsingException;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001M\u0011\u0001#\u00138eKb,GmQ*W!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011A\u00029beN,'O\u0003\u0002\u0006\r\u00051!/Z1eKJT!a\u0002\u0005\u0002\u0007\r\u001chO\u0003\u0002\n\u0015\u00051Qn\u001c3vY\u0016T!a\u0003\u0007\u0002\u0005Y\u0014$BA\u0007\u000f\u0003\u00159X-\u0019<f\u0015\ty\u0001#\u0001\u0003nk2,'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u00195K\u0016)beN,'\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u00035\u0019wN\u001c;f]R\u0014V-\u00193feV\t1\u0004\u0005\u0002\u001d=5\tQD\u0003\u0002\u0006\u0011%\u0011q$\b\u0002\r'>,(oY3SK\u0006$WM\u001d\u0005\tC\u0001\u0011\t\u0011)A\u00057\u0005q1m\u001c8uK:$(+Z1eKJ\u0004\u0003\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013(\u0003-\u00197KV*fiRLgnZ:\u0011\u0005U)\u0013B\u0001\u0014\u0003\u0005-\u00195KV*fiRLgnZ:\n\u0005\r2\u0002\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002,Y5\u0002\"!\u0006\u0001\t\u000beA\u0003\u0019A\u000e\t\u000b\rB\u0003\u0019\u0001\u0013\t\u000f=\u0002!\u0019!C\u0001a\u0005a!/Z2pe\u0012$vn[3ogV\t\u0011\u0007\u0005\u0002\u001de%\u00111'\b\u0002\u0011\t\u00164\u0017-\u001e7u\u0019>tw-\u0011:sCfDa!\u000e\u0001!\u0002\u0013\t\u0014!\u0004:fG>\u0014H\rV8lK:\u001c\b\u0005C\u00048\u0001\t\u0007I\u0011\u0001\u001d\u0002\u0015\r\u001ch/\u00128ue&,7/F\u0001:!\tQd(D\u0001<\u0015\t)AH\u0003\u0002>\u0011\u0005\u0019\u00010\u001c7\n\u0005}Z$A\u0003+pW\u0016t\u0017I\u001d:bs\"1\u0011\t\u0001Q\u0001\ne\n1bY:w\u000b:$(/[3tA!91\t\u0001a\u0001\n\u0003!\u0015\u0001\u00037pG\u0006$\u0018n\u001c8\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013A\u0001T8oO\"9A\n\u0001a\u0001\n\u0003i\u0015\u0001\u00047pG\u0006$\u0018n\u001c8`I\u0015\fHC\u0001(R!\t1u*\u0003\u0002Q\u000f\n!QK\\5u\u0011\u001d\u00116*!AA\u0002\u0015\u000b1\u0001\u001f\u00132\u0011\u0019!\u0006\u0001)Q\u0005\u000b\u0006IAn\\2bi&|g\u000e\t\u0005\u0006-\u0002!\taV\u0001\tG>tG/Y5ogR\u0011\u0001l\u0017\t\u0003\rfK!AW$\u0003\u000f\t{w\u000e\\3b]\")A,\u0016a\u0001;\u0006)\u0011N\u001c3fqB\u0011aIX\u0005\u0003?\u001e\u00131!\u00138u\u0011\u0015\t\u0007\u0001\"\u0001c\u0003\r9W\r\u001e\u000b\u0003G\u001a\u0004\"!\u00063\n\u0005\u0015\u0014!!C\"T-J+7m\u001c:e\u0011\u0015a\u0006\r1\u0001^\u0011\u0015A\u0007\u0001\"\u0001j\u0003!\u00198.\u001b9MS:,G#\u0001(\t\u000b-\u0004A\u0011\u00027\u0002\u0013\u0015dW-\\3oi\u0006#HCA7\u0000!\r1e\u000e]\u0005\u0003_\u001e\u0013aa\u00149uS>t\u0007cA9zy:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003kJ\ta\u0001\u0010:p_Rt\u0014\"\u0001%\n\u0005a<\u0015a\u00029bG.\fw-Z\u0005\u0003un\u00141aU3r\u0015\tAx\t\u0005\u0002\u0016{&\u0011aP\u0001\u0002\u0010\u0013:$W\r_3e\u0007N3VI\u001c;ss\")AL\u001ba\u0001;\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0011!\u00029beN,G#\u00019")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader contentReader;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;

    public SourceReader contentReader() {
        return this.contentReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean contains(int index) {
        return this.recordTokens().size() > (long)index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(int index) {
        Option<Seq<IndexedCSVEntry>> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new CSVParsingException(index + " is out of bound max is " + this.recordTokens().size(), (Location)UnknownLocation$.MODULE$);
        }
        return new CSVRecord((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.headers(), this.headersWithIndex(), new IndexedCSVRecordLocation((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.contentReader()));
    }

    @Override
    public void skipLine() {
        this.contentReader().seek(this.location());
        char next = this.contentReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.contentReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.contentReader().readAscii();
                next = this.contentReader().lookAheadAscii();
                this.location_$eq(this.contentReader().position());
            }
        }
    }

    private Option<Seq<IndexedCSVEntry>> elementAt(int index) {
        None$ none$;
        long size;
        if (this.headers().isEmpty()) {
            boolean hasHeaderLine;
            int headerLine = super.cSVSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.cSVSettings().header()) {
                this.processHeaders(this.parse());
            }
            this.skipLines(this.linesToSkipBeforeBody());
        }
        if ((size = this.recordTokens().size()) <= (long)index) {
            for (long remaining = (long)index - size; remaining >= 0L; --remaining) {
                Seq<IndexedCSVEntry> nextRecord = this.parse();
                if (!nextRecord.nonEmpty()) continue;
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length();
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((Seq<long[]>)((Seq)nextRecord.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Seq$.MODULE$.canBuildFrom())));
                if (remaining != 0L) continue;
                return new Some(nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply((long)index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.contentReader(), this.escape());
            none$ = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])record));
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<IndexedCSVEntry> parse() {
        void var2_1;
        ArrayBuffer indexedEntries;
        do {
            BoxedUnit boxedUnit;
            this.contentReader().seek(this.location());
            indexedEntries = new ArrayBuffer();
            boolean insideQuotations = false;
            boolean recordEnded = false;
            long valueIndex = this.contentReader().position();
            long size = -1L;
            char value = this.contentReader().readAscii();
            if (value != '\uffff') {
                while (!recordEnded && value != '\uffff') {
                    Object object;
                    char next = value;
                    if (insideQuotations) {
                        if (this.isEscapeChar(next) && this.isQuoteChar(this.contentReader().lookAheadAscii())) {
                            object = BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii());
                        } else {
                            if (this.isQuoteChar(next)) {
                                insideQuotations = false;
                                size = this.contentReader().previousPosition() - valueIndex;
                            }
                            object = BoxedUnit.UNIT;
                        }
                    } else if (this.isEscapeChar(next) && this.requiredEscape(this.contentReader().lookAheadAscii())) {
                        object = BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii());
                    } else {
                        if (this.isQuoteChar(next)) {
                            insideQuotations = true;
                            valueIndex = this.contentReader().position();
                        } else if (this.isEntrySeparator(next)) {
                            size = size == -1L ? this.contentReader().previousPosition() - valueIndex : size;
                            long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size);
                            indexedEntries.$plus$eq((Object)new IndexedCSVEntry(token, this.contentReader(), this.escape()));
                            valueIndex = this.contentReader().position();
                            size = -1L;
                        } else if (this.isLineEnding(next)) {
                            size = size == -1L ? this.contentReader().previousPosition() - valueIndex : size;
                            long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size);
                            indexedEntries.$plus$eq((Object)new IndexedCSVEntry(token, this.contentReader(), this.escape()));
                            Object object2 = next == '\r' && this.contentReader().lookAheadAscii() == '\n' ? BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii()) : BoxedUnit.UNIT;
                            recordEnded = true;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    if (recordEnded) continue;
                    value = this.contentReader().readAscii();
                }
                if (!recordEnded) {
                    size = size == -1L ? this.contentReader().position() - valueIndex : size;
                    long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size);
                    boxedUnit = indexedEntries.$plus$eq((Object)new IndexedCSVEntry(token, this.contentReader(), this.escape()));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.location_$eq(this.contentReader().position());
        } while (super.cSVSettings().ignoreEmptyLine() && indexedEntries.size() == 1 && ((IndexedCSVEntry)indexedEntries.apply(0)).length() == 0L);
        return var2_1;
    }

    public IndexedCSVParser(SourceReader contentReader, CSVSettings cSVSettings) {
        this.contentReader = contentReader;
        super(cSVSettings);
        this.registerCloseable(contentReader);
        this.recordTokens = this.registerCloseable(new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1()));
        this.csvEntries = this.registerCloseable(new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1()));
        this.location = 0L;
    }
}

