/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJAnnotationValue;
import com.helger.jcodemodel.AbstractJAnnotationValueOwned;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAnnotationWriter;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.TypedAnnotationWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JAnnotationArrayMember
extends AbstractJAnnotationValueOwned
implements IJAnnotatable {
    private final JCodeModel _owner;
    private final List<AbstractJAnnotationValue> _values = new ArrayList<AbstractJAnnotationValue>();

    public JAnnotationArrayMember(@Nonnull JCodeModel jCodeModel) {
        if (jCodeModel == null) {
            throw new NullPointerException("owner");
        }
        this._owner = jCodeModel;
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this._owner;
    }

    @Nonnull
    public JAnnotationArrayMember param(String string) {
        this._values.add(JAnnotationArrayMember.wrap(string));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(String ... stringArray) {
        for (String string : stringArray) {
            this._values.add(JAnnotationArrayMember.wrap(string));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(boolean bl) {
        this._values.add(JAnnotationArrayMember.wrap(bl));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(boolean ... blArray) {
        for (boolean bl : blArray) {
            this._values.add(JAnnotationArrayMember.wrap(bl));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(byte by) {
        this._values.add(JAnnotationArrayMember.wrap(by));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(byte ... byArray) {
        for (byte by : byArray) {
            this._values.add(JAnnotationArrayMember.wrap(by));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(char c) {
        this._values.add(JAnnotationArrayMember.wrap(c));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(char ... cArray) {
        for (char c : cArray) {
            this._values.add(JAnnotationArrayMember.wrap(c));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(double d) {
        this._values.add(JAnnotationArrayMember.wrap(d));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(double ... dArray) {
        for (double d : dArray) {
            this._values.add(JAnnotationArrayMember.wrap(d));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(long l) {
        this._values.add(JAnnotationArrayMember.wrap(l));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(long ... lArray) {
        for (long l : lArray) {
            this._values.add(JAnnotationArrayMember.wrap(l));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(short s) {
        this._values.add(JAnnotationArrayMember.wrap(s));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(short ... sArray) {
        for (short s : sArray) {
            this._values.add(JAnnotationArrayMember.wrap(s));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(int n) {
        this._values.add(JAnnotationArrayMember.wrap(n));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(int ... nArray) {
        for (int n : nArray) {
            this._values.add(JAnnotationArrayMember.wrap(n));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(float f) {
        this._values.add(JAnnotationArrayMember.wrap(f));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(float ... fArray) {
        for (float f : fArray) {
            this._values.add(JAnnotationArrayMember.wrap(f));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(@Nonnull Enum<?> enum_) {
        this._values.add(this.wrap(enum_));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(Enum<?> ... enumArray) {
        for (Enum<?> enum_ : enumArray) {
            this._values.add(this.wrap(enum_));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(JEnumConstant jEnumConstant) {
        this._values.add(JAnnotationArrayMember.wrap(jEnumConstant));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(JEnumConstant ... jEnumConstantArray) {
        for (JEnumConstant jEnumConstant : jEnumConstantArray) {
            this._values.add(JAnnotationArrayMember.wrap(jEnumConstant));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(IJExpression iJExpression) {
        this._values.add(JAnnotationArrayMember.wrap(iJExpression));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(IJExpression ... iJExpressionArray) {
        for (IJExpression iJExpression : iJExpressionArray) {
            this._values.add(JAnnotationArrayMember.wrap(iJExpression));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(Class<?> clazz) {
        this._values.add(this.wrap(clazz));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this._values.add(this.wrap(clazz));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(AbstractJType abstractJType) {
        this._values.add(JAnnotationArrayMember.wrap(abstractJType));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(AbstractJType ... abstractJTypeArray) {
        for (AbstractJType abstractJType : abstractJTypeArray) {
            this._values.add(JAnnotationArrayMember.wrap(abstractJType));
        }
        return this;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this._values.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public <W extends IJAnnotationWriter<?>> W annotate2(@Nonnull Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this._values);
    }

    @Nonnull
    public Collection<AbstractJAnnotationValue> getAllAnnotations() {
        return Collections.unmodifiableList(this._values);
    }

    @Nonnegative
    public int size() {
        return this._values.size();
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print('{').newline().indent();
        boolean bl = true;
        for (AbstractJAnnotationValue abstractJAnnotationValue : this._values) {
            if (!bl) {
                jFormatter.print(',').newline();
            }
            jFormatter.generable(abstractJAnnotationValue);
            bl = false;
        }
        jFormatter.newline().outdent().print('}');
    }
}

