/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJOwnedMaybe;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JTypeVarClass;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JInvocation
extends AbstractJExpressionImpl
implements IJStatement,
IJOwnedMaybe {
    private final JCodeModel m_aOwner;
    private final IJGenerable m_aObject;
    private final String m_sMethodName;
    private final JMethod m_sMethod;
    private final boolean m_bIsConstructor;
    private final List<IJExpression> _args = new ArrayList<IJExpression>();
    private final AbstractJType m_aConstructorType;
    private List<JTypeVar> _typeVariables;

    protected JInvocation(@Nullable IJExpression iJExpression, @Nonnull String string) {
        this(null, (IJGenerable)iJExpression, string);
    }

    protected JInvocation(@Nullable IJExpression iJExpression, @Nonnull JMethod jMethod) {
        this(jMethod.owner(), (IJGenerable)iJExpression, jMethod);
    }

    protected JInvocation(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        this(abstractJClass.owner(), (IJGenerable)abstractJClass, string);
    }

    protected JInvocation(@Nonnull AbstractJClass abstractJClass, @Nonnull JMethod jMethod) {
        this(abstractJClass.owner(), (IJGenerable)abstractJClass, jMethod);
    }

    private JInvocation(@Nullable JCodeModel jCodeModel, @Nullable IJGenerable iJGenerable, @Nonnull String string) {
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("method name contains '.': " + string);
        }
        this.m_aOwner = jCodeModel;
        this.m_aObject = iJGenerable;
        this.m_sMethodName = string;
        this.m_sMethod = null;
        this.m_bIsConstructor = false;
        this.m_aConstructorType = null;
    }

    private JInvocation(@Nonnull JCodeModel jCodeModel, @Nullable IJGenerable iJGenerable, @Nonnull JMethod jMethod) {
        this.m_aOwner = jCodeModel;
        this.m_aObject = iJGenerable;
        this.m_sMethodName = null;
        this.m_sMethod = jMethod;
        this.m_bIsConstructor = false;
        this.m_aConstructorType = null;
    }

    protected JInvocation(@Nonnull AbstractJType abstractJType) {
        this.m_aOwner = abstractJType.owner();
        this.m_aObject = null;
        this.m_sMethodName = null;
        this.m_sMethod = null;
        this.m_bIsConstructor = true;
        this.m_aConstructorType = abstractJType;
    }

    @Override
    @Nullable
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    public boolean isConstructor() {
        return this.m_bIsConstructor;
    }

    @Nonnull
    public JInvocation arg(@Nonnull IJExpression iJExpression) {
        if (iJExpression == null) {
            throw new IllegalArgumentException("argument may not be null");
        }
        this._args.add(iJExpression);
        return this;
    }

    @Nonnull
    public JInvocation arg(@Nonnull boolean bl) {
        return this.arg(JExpr.lit(bl));
    }

    @Nonnull
    public JInvocation arg(@Nonnull char c) {
        return this.arg(JExpr.lit(c));
    }

    @Nonnull
    public JInvocation arg(@Nonnull double d) {
        return this.arg(JExpr.lit(d));
    }

    @Nonnull
    public JInvocation arg(@Nonnull float f) {
        return this.arg(JExpr.lit(f));
    }

    @Nonnull
    public JInvocation arg(@Nonnull int n) {
        return this.arg(JExpr.lit(n));
    }

    @Nonnull
    public JInvocation arg(@Nonnull long l) {
        return this.arg(JExpr.lit(l));
    }

    @Nonnull
    public JInvocation arg(@Nonnull String string) {
        return this.arg(JExpr.lit(string));
    }

    @Nonnull
    public IJExpression[] listArgs() {
        return this._args.toArray(new IJExpression[this._args.size()]);
    }

    @Nonnull
    public List<IJExpression> args() {
        return new ArrayList<IJExpression>(this._args);
    }

    @Nonnull
    private JCodeModel _narrowOwner() {
        JCodeModel jCodeModel = this.owner();
        if (jCodeModel == null) {
            throw new IllegalStateException("No owner is present, so this invocation cannot be generified!");
        }
        return jCodeModel;
    }

    @Nonnull
    public JInvocation narrow(@Nonnull String string) {
        JTypeVar jTypeVar = new JTypeVar(this._narrowOwner(), string);
        if (this._typeVariables == null) {
            this._typeVariables = new ArrayList<JTypeVar>(3);
        }
        this._typeVariables.add(jTypeVar);
        return this;
    }

    @Nonnull
    public JInvocation narrow(@Nonnull Class<?> clazz) {
        return this.narrow(this._narrowOwner().ref(clazz));
    }

    @Nonnull
    public JInvocation narrow(@Nonnull AbstractJClass abstractJClass) {
        JTypeVarClass jTypeVarClass = new JTypeVarClass(abstractJClass);
        if (this._typeVariables == null) {
            this._typeVariables = new ArrayList<JTypeVar>(3);
        }
        this._typeVariables.add(jTypeVarClass);
        return this;
    }

    @Nonnull
    public List<JTypeVar> typeParamList() {
        if (this._typeVariables == null) {
            return Collections.emptyList();
        }
        return new ArrayList<JTypeVar>(this._typeVariables);
    }

    private void _addTypeVars(@Nonnull JFormatter jFormatter) {
        if (this._typeVariables != null && !this._typeVariables.isEmpty()) {
            jFormatter.print('<');
            int n = 0;
            for (JTypeVar jTypeVar : this._typeVariables) {
                if (n++ > 0) {
                    jFormatter.print(',');
                }
                jFormatter.type(jTypeVar);
            }
            jFormatter.print('\uffff');
        }
    }

    private String methodName() {
        return this.m_sMethodName != null ? this.m_sMethodName : this.m_sMethod.name();
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.m_bIsConstructor) {
            if (this.m_aConstructorType.isArray()) {
                jFormatter.print("new").generable(this.m_aConstructorType);
                this._addTypeVars(jFormatter);
                jFormatter.print('{');
            } else {
                jFormatter.print("new").generable(this.m_aConstructorType);
                this._addTypeVars(jFormatter);
                jFormatter.print('(');
            }
        } else {
            String string = this.methodName();
            if (this.m_aObject != null) {
                jFormatter.generable(this.m_aObject).print('.');
                this._addTypeVars(jFormatter);
                jFormatter.print(string).print('(');
            } else {
                jFormatter.id(string).print('(');
            }
        }
        jFormatter.generable(this._args);
        if (this.m_bIsConstructor && this.m_aConstructorType.isArray()) {
            jFormatter.print('}');
        } else {
            jFormatter.print(')');
        }
        if (this.m_aConstructorType instanceof JDefinedClass && ((JDefinedClass)this.m_aConstructorType).isAnonymous()) {
            ((JAnonymousClass)this.m_aConstructorType).declareBody(jFormatter);
        }
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.generable(this).print(';').newline();
    }

    private String typeFullName() {
        return this.m_aConstructorType != null ? this.m_aConstructorType.fullName() : "";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JInvocation jInvocation = (JInvocation)object;
        if (!(JCEqualsHelper.isEqual(this.m_aObject, jInvocation.m_aObject) && JCEqualsHelper.isEqual(this.m_bIsConstructor, jInvocation.m_bIsConstructor) && (this.m_bIsConstructor || JCEqualsHelper.isEqual(this.methodName(), jInvocation.methodName())) && JCEqualsHelper.isEqual(this._args, jInvocation._args) && JCEqualsHelper.isEqual(this.typeFullName(), jInvocation.typeFullName()))) {
            return false;
        }
        if (this._typeVariables == null) {
            return jInvocation._typeVariables == null;
        }
        if (jInvocation._typeVariables == null) {
            return false;
        }
        if (this._typeVariables.size() != jInvocation._typeVariables.size()) {
            return false;
        }
        for (int i = 0; i < this._typeVariables.size(); ++i) {
            if (JCEqualsHelper.isEqual(this._typeVariables.get(i).fullName(), jInvocation._typeVariables.get(i).fullName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        JCHashCodeGenerator jCHashCodeGenerator = new JCHashCodeGenerator(this).append(this.m_aObject).append(this.m_bIsConstructor);
        if (!this.m_bIsConstructor) {
            jCHashCodeGenerator = jCHashCodeGenerator.append(this.methodName());
        }
        jCHashCodeGenerator = jCHashCodeGenerator.append(this._args).append(this.typeFullName());
        if (this._typeVariables != null) {
            jCHashCodeGenerator = jCHashCodeGenerator.append(this._typeVariables.size());
            for (JTypeVar jTypeVar : this._typeVariables) {
                jCHashCodeGenerator = jCHashCodeGenerator.append(jTypeVar.fullName());
            }
        }
        return jCHashCodeGenerator.getHashCode();
    }
}

