/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJExpressionStatement;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JAssignment
extends AbstractJExpressionImpl
implements IJExpressionStatement {
    private final IJAssignmentTarget _lhs;
    private final IJExpression _rhs;
    private final String _op;

    protected JAssignment(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this(iJAssignmentTarget, iJExpression, "");
    }

    protected JAssignment(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression, @Nonnull String string) {
        this._lhs = iJAssignmentTarget;
        this._rhs = iJExpression;
        this._op = string;
    }

    @Nonnull
    public IJAssignmentTarget lhs() {
        return this._lhs;
    }

    @Nonnull
    public IJExpression rhs() {
        return this._rhs;
    }

    @Nonnull
    public String op() {
        return this._op;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.generable(this._lhs).print(this._op + '=').generable(this._rhs);
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.generable(this).print(';').newline();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JAssignment jAssignment = (JAssignment)object;
        return JCEqualsHelper.isEqual(this._lhs, jAssignment._lhs) && JCEqualsHelper.isEqual(this._rhs, jAssignment._rhs) && JCEqualsHelper.isEqual(this._op, jAssignment._op);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this._lhs, this._rhs, this._op);
    }
}

