/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JEnumConstantRef
extends AbstractJExpressionImpl {
    private final AbstractJClass _type;
    private final String _name;

    protected JEnumConstantRef(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        if (abstractJClass == null) {
            throw new NullPointerException("type");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this._type = abstractJClass;
        this._name = string;
    }

    @Nonnull
    public AbstractJClass type() {
        return this._type;
    }

    @Nonnull
    public String name() {
        return this._name;
    }

    @Nonnull
    public String getName() {
        return this._type.fullName() + '.' + this._name;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.type(this._type).print('.').print(this._name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JEnumConstantRef jEnumConstantRef = (JEnumConstantRef)object;
        return JCEqualsHelper.isEqual(this._type.fullName(), jEnumConstantRef._type.fullName()) && JCEqualsHelper.isEqual(this._name, jEnumConstantRef._name);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this._type.fullName(), this._name);
    }
}

