/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JVar;
import javax.annotation.Nonnull;

public class JForEach
implements IJStatement {
    private final AbstractJType m_aType;
    private final String m_sVarName;
    private JBlock m_aBody;
    private final IJExpression m_aCollection;
    private final JVar m_aLopVar;

    protected JForEach(@Nonnull AbstractJType abstractJType, @Nonnull String string, @Nonnull IJExpression iJExpression) {
        if (abstractJType == null) {
            throw new NullPointerException("Variable Type");
        }
        if (string == null) {
            throw new NullPointerException("Variable name");
        }
        if (iJExpression == null) {
            throw new NullPointerException("Collection expression");
        }
        this.m_aType = abstractJType;
        this.m_sVarName = string;
        this.m_aCollection = iJExpression;
        this.m_aLopVar = new JVar(JMods.forVar(8), this.m_aType, this.m_sVarName, iJExpression);
    }

    @Nonnull
    public AbstractJType type() {
        return this.m_aType;
    }

    @Nonnull
    public JVar var() {
        return this.m_aLopVar;
    }

    @Nonnull
    public IJExpression collection() {
        return this.m_aCollection;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.print("for (");
        jFormatter.generable(this.m_aType).id(this.m_sVarName).print(": ").generable(this.m_aCollection);
        jFormatter.print(')');
        if (this.m_aBody != null) {
            jFormatter.generable(this.m_aBody);
        } else {
            jFormatter.print(';');
        }
        jFormatter.newline();
    }
}

