/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JTypeVar;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JTypeWildcard
extends AbstractJClass {
    private final AbstractJClass m_aBoundClass;
    private final EBoundMode m_eBoundMode;

    protected JTypeWildcard(@Nonnull AbstractJClass abstractJClass, @Nonnull EBoundMode eBoundMode) {
        super(abstractJClass.owner());
        this.m_aBoundClass = abstractJClass;
        this.m_eBoundMode = eBoundMode;
    }

    @Nonnull
    public AbstractJClass bound() {
        return this.m_aBoundClass;
    }

    @Override
    @Nonnull
    public AbstractJType declarable() {
        return this.m_aBoundClass;
    }

    @Override
    public boolean containsTypeVar(@Nullable JTypeVar jTypeVar) {
        return this.m_aBoundClass.containsTypeVar(jTypeVar);
    }

    @Nonnull
    public EBoundMode boundMode() {
        return this.m_eBoundMode;
    }

    @Override
    @Nonnull
    public String name() {
        return this.m_eBoundMode.declarationTokens() + this.m_aBoundClass.name();
    }

    @Override
    @Nonnull
    public String fullName() {
        return this.m_eBoundMode.declarationTokens() + this.m_aBoundClass.fullName();
    }

    @Override
    @Nullable
    public JPackage _package() {
        return null;
    }

    @Override
    public AbstractJClass _extends() {
        return this.m_eBoundMode == EBoundMode.EXTENDS ? this.m_aBoundClass : this._package().owner().ref(Object.class);
    }

    @Override
    @Nonnull
    public Iterator<AbstractJClass> _implements() {
        return this.m_aBoundClass._implements();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isError() {
        return this.m_aBoundClass.isError();
    }

    @Override
    @Nonnull
    protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
        AbstractJClass abstractJClass = this.m_aBoundClass.substituteParams(jTypeVarArray, list);
        if (abstractJClass == this.m_aBoundClass) {
            return this;
        }
        return new JTypeWildcard(abstractJClass, EBoundMode.EXTENDS);
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.m_aBoundClass._extends() == null) {
            jFormatter.print("?");
        } else {
            jFormatter.print(this.m_eBoundMode.declarationTokens()).generable(this.m_aBoundClass);
        }
    }

    public static enum EBoundMode {
        EXTENDS("? extends "),
        SUPER("? super ");

        private final String m_sDeclarationTokens;

        private EBoundMode(String string2) {
            this.m_sDeclarationTokens = string2;
        }

        @Nonnull
        public String declarationTokens() {
            return this.m_sDeclarationTokens;
        }
    }
}

