/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileCodeWriter
extends AbstractCodeWriter {
    public static final boolean DEFAULT_MARK_READ_ONLY = false;
    public static final Charset DEFAULT_CHARSET = null;
    private final File m_aTargetDir;
    private final boolean m_bMarkReadOnly;
    private final Set<File> m_aReadOnlyFiles = new HashSet<File>();

    public FileCodeWriter(@Nonnull File file) throws IOException {
        this(file, false, DEFAULT_CHARSET, FileCodeWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, @Nullable Charset charset) throws IOException {
        this(file, false, charset, FileCodeWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, boolean bl) throws IOException {
        this(file, bl, DEFAULT_CHARSET, FileCodeWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, @Nullable Charset charset, @Nonnull String string) throws IOException {
        this(file, false, charset, string);
    }

    public FileCodeWriter(@Nonnull File file, boolean bl, @Nullable Charset charset) throws IOException {
        this(file, bl, charset, FileCodeWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, boolean bl, @Nullable Charset charset, @Nonnull String string) throws IOException {
        super(charset, string);
        this.m_aTargetDir = file;
        this.m_bMarkReadOnly = bl;
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(file + ": non-existent directory");
        }
    }

    @Override
    @Nonnull
    public OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        return new FileOutputStream(this.getFile(jPackage, string));
    }

    @Nonnull
    protected File getFile(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        File file;
        File file2 = jPackage.isUnnamed() ? this.m_aTargetDir : new File(this.m_aTargetDir, FileCodeWriter._toDirName(jPackage));
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(file2, string)).exists() && !file.delete()) {
            throw new IOException(file + ": Can't delete previous version");
        }
        if (this.m_bMarkReadOnly) {
            this.m_aReadOnlyFiles.add(file);
        }
        return file;
    }

    @Override
    public void close() throws IOException {
        for (File file : this.m_aReadOnlyFiles) {
            file.setReadOnly();
        }
    }

    private static String _toDirName(@Nonnull JPackage jPackage) {
        return jPackage.name().replace('.', File.separatorChar);
    }
}

