/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.JPackage;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;

public class SingleStreamCodeWriter
extends AbstractCodeWriter {
    private final PrintStream m_aPS;
    private final boolean m_bDoClose;

    public SingleStreamCodeWriter(@Nonnull OutputStream outputStream) {
        this(outputStream, SingleStreamCodeWriter.getDefaultNewLine());
    }

    public SingleStreamCodeWriter(@Nonnull OutputStream outputStream, @Nonnull String string) {
        super(null, string);
        this.m_bDoClose = outputStream != System.out && outputStream != System.err;
        this.m_aPS = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
    }

    @Override
    public OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        String string2 = jPackage.name();
        if (string2.length() > 0) {
            string2 = string2 + '.';
        }
        this.m_aPS.println("-----------------------------------" + string2 + string + "-----------------------------------");
        return new FilterOutputStream(this.m_aPS){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.m_aPS.flush();
        if (this.m_bDoClose) {
            this.m_aPS.close();
        }
    }
}

