/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JNarrowedClass
extends AbstractJClass {
    private final AbstractJClass m_aBasis;
    private final List<? extends AbstractJClass> m_aArgs;

    public JNarrowedClass(@Nonnull AbstractJClass abstractJClass, @Nonnull AbstractJClass abstractJClass2) {
        this(abstractJClass, Collections.singletonList(abstractJClass2));
    }

    public JNarrowedClass(@Nonnull AbstractJClass abstractJClass, @Nonnull List<? extends AbstractJClass> list) {
        super(abstractJClass.owner());
        if (abstractJClass instanceof JNarrowedClass) {
            throw new IllegalArgumentException("basis may not be a narrowed class: " + abstractJClass);
        }
        JCValueEnforcer.notNull(list, "NarrowingClass");
        this.m_aBasis = abstractJClass;
        this.m_aArgs = list;
    }

    @Override
    public boolean containsTypeVar(@Nullable JTypeVar jTypeVar) {
        if (this.m_aBasis.containsTypeVar(jTypeVar)) {
            return true;
        }
        for (AbstractJClass abstractJClass : this.m_aArgs) {
            if (!abstractJClass.containsTypeVar(jTypeVar)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public AbstractJClass basis() {
        return this.m_aBasis;
    }

    @Override
    public JNarrowedClass narrow(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.notNull(abstractJClass, "NarrowingClass");
        ArrayList<? extends AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this.m_aArgs);
        arrayList.add(abstractJClass);
        return new JNarrowedClass(this.m_aBasis, arrayList);
    }

    @Override
    public JNarrowedClass narrow(AbstractJClass ... abstractJClassArray) {
        JCValueEnforcer.notNull(abstractJClassArray, "NarrowingClass");
        ArrayList<? extends AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this.m_aArgs);
        for (AbstractJClass abstractJClass : abstractJClassArray) {
            arrayList.add(abstractJClass);
        }
        return new JNarrowedClass(this.m_aBasis, arrayList);
    }

    @Override
    public String name() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_aBasis.name()).append('<');
        boolean bl = true;
        for (AbstractJClass abstractJClass : this.m_aArgs) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(abstractJClass.name());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public String fullName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_aBasis.fullName());
        stringBuilder.append('<');
        boolean bl = true;
        for (AbstractJClass abstractJClass : this.m_aArgs) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(abstractJClass.fullName());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public String binaryName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_aBasis.binaryName());
        stringBuilder.append('<');
        boolean bl = true;
        for (AbstractJClass abstractJClass : this.m_aArgs) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(abstractJClass.binaryName());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public void generate(JFormatter jFormatter) {
        jFormatter.type(this.m_aBasis).print('<').generable(this.m_aArgs).print('\uffff');
    }

    @Override
    void printLink(JFormatter jFormatter) {
        this.m_aBasis.printLink(jFormatter);
        jFormatter.print("{@code <}");
        boolean bl = true;
        for (AbstractJClass abstractJClass : this.m_aArgs) {
            if (bl) {
                bl = false;
            } else {
                jFormatter.print(',');
            }
            abstractJClass.printLink(jFormatter);
        }
        jFormatter.print("{@code >}");
    }

    @Override
    @Nonnull
    public JPackage _package() {
        return this.m_aBasis._package();
    }

    @Override
    @Nullable
    public AbstractJClass _extends() {
        AbstractJClass abstractJClass = this.m_aBasis._extends();
        if (abstractJClass == null) {
            return abstractJClass;
        }
        return abstractJClass.substituteParams(this.m_aBasis.typeParams(), this.m_aArgs);
    }

    @Override
    @Nonnull
    public Iterator<AbstractJClass> _implements() {
        return new Iterator<AbstractJClass>(){
            private final Iterator<AbstractJClass> core;
            {
                this.core = JNarrowedClass.this.m_aBasis._implements();
            }

            @Override
            public void remove() {
                this.core.remove();
            }

            @Override
            public AbstractJClass next() {
                return this.core.next().substituteParams(JNarrowedClass.this.m_aBasis.typeParams(), JNarrowedClass.this.m_aArgs);
            }

            @Override
            public boolean hasNext() {
                return this.core.hasNext();
            }
        };
    }

    @Override
    @Nonnull
    public AbstractJClass erasure() {
        return this.m_aBasis;
    }

    @Override
    public boolean isInterface() {
        return this.m_aBasis.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this.m_aBasis.isAbstract();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isError() {
        if (this.m_aBasis.isError()) {
            return true;
        }
        for (AbstractJClass abstractJClass : this.m_aArgs) {
            if (!abstractJClass.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends AbstractJClass> getTypeParameters() {
        return this.m_aArgs;
    }

    @Override
    protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
        AbstractJClass abstractJClass = this.m_aBasis.substituteParams(jTypeVarArray, list);
        boolean bl = abstractJClass != this.m_aBasis;
        ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this.m_aArgs.size());
        for (AbstractJClass abstractJClass2 : this.m_aArgs) {
            AbstractJClass abstractJClass3 = abstractJClass2.substituteParams(jTypeVarArray, list);
            arrayList.add(abstractJClass3);
            bl |= abstractJClass3 != abstractJClass2;
        }
        if (bl) {
            return new JNarrowedClass(abstractJClass, arrayList);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JNarrowedClass jNarrowedClass = (JNarrowedClass)object;
        return this.m_aBasis.equals(jNarrowedClass.m_aBasis) && this.m_aArgs.equals(jNarrowedClass.m_aArgs);
    }

    public int hashCode() {
        return this.m_aBasis.hashCode() * 37 + this.m_aArgs.hashCode();
    }
}

