/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JOpUnary
extends AbstractJExpressionImpl {
    private final String m_sOperator;
    private final IJExpression m_aExpr;
    private final boolean m_bOperatorComesFirst;

    protected JOpUnary(@Nonnull String string, @Nonnull IJExpression iJExpression) {
        this.m_sOperator = JCValueEnforcer.notNull(string, "Operator");
        this.m_aExpr = JCValueEnforcer.notNull(iJExpression, "Expression");
        this.m_bOperatorComesFirst = true;
    }

    protected JOpUnary(@Nonnull IJExpression iJExpression, @Nonnull String string) {
        this.m_sOperator = JCValueEnforcer.notNull(string, "Operator");
        this.m_aExpr = JCValueEnforcer.notNull(iJExpression, "Expression");
        this.m_bOperatorComesFirst = false;
    }

    @Nonnull
    public String op() {
        return this.m_sOperator;
    }

    @Nonnull
    public IJExpression expr() {
        return this.m_aExpr;
    }

    public boolean opFirst() {
        return this.m_bOperatorComesFirst;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.m_bOperatorComesFirst) {
            jFormatter.print('(').print(this.m_sOperator).generable(this.m_aExpr).print(')');
        } else {
            jFormatter.print('(').generable(this.m_aExpr).print(this.m_sOperator).print(')');
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JOpUnary jOpUnary = (JOpUnary)object;
        return JCEqualsHelper.isEqual(this.m_sOperator, jOpUnary.m_sOperator) && JCEqualsHelper.isEqual(this.m_aExpr, jOpUnary.m_aExpr) && JCEqualsHelper.isEqual(this.m_bOperatorComesFirst, jOpUnary.m_bOperatorComesFirst);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_sOperator, this.m_aExpr, this.m_bOperatorComesFirst);
    }
}

