/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JStringLiteral
extends AbstractJExpressionImpl {
    private String m_sWhat;

    protected JStringLiteral(@Nonnull String string) {
        this.what(string);
    }

    @Nonnull
    public String what() {
        return this.m_sWhat;
    }

    public void what(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("String may not be null");
        }
        this.m_sWhat = string;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print(JExpr.quotify('\"', this.m_sWhat));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JStringLiteral jStringLiteral = (JStringLiteral)object;
        return JCEqualsHelper.isEqual(this.m_sWhat, jStringLiteral.m_sWhat);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_sWhat);
    }
}

