/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJOwned;
import com.helger.jcodemodel.JArrayClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JNullType;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JTypeWildcard;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractJType
implements IJGenerable,
IJOwned {
    @Nonnull
    public static JPrimitiveType parse(@Nonnull JCodeModel jCodeModel, @Nonnull String string) {
        if (string.equals("void")) {
            return jCodeModel.VOID;
        }
        if (string.equals("boolean")) {
            return jCodeModel.BOOLEAN;
        }
        if (string.equals("byte")) {
            return jCodeModel.BYTE;
        }
        if (string.equals("short")) {
            return jCodeModel.SHORT;
        }
        if (string.equals("char")) {
            return jCodeModel.CHAR;
        }
        if (string.equals("int")) {
            return jCodeModel.INT;
        }
        if (string.equals("float")) {
            return jCodeModel.FLOAT;
        }
        if (string.equals("long")) {
            return jCodeModel.LONG;
        }
        if (string.equals("double")) {
            return jCodeModel.DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + string);
    }

    @Nullable
    public abstract String fullName();

    @Nonnull
    public String binaryName() {
        return this.fullName();
    }

    @Nonnull
    public abstract String name();

    public abstract JArrayClass array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    @Nonnull
    public abstract AbstractJClass boxify();

    @Nonnull
    public abstract AbstractJType unboxify();

    @Nonnull
    public AbstractJType erasure() {
        return this;
    }

    @Nonnull
    public AbstractJType declarable() {
        return this;
    }

    public final boolean isReference() {
        return !this.isPrimitive();
    }

    @Nonnull
    public AbstractJType elementType() {
        throw new IllegalArgumentException("Not an array type: " + this.fullName());
    }

    public boolean containsTypeVar(@Nullable JTypeVar jTypeVar) {
        return false;
    }

    public boolean isAssignableFrom(@Nonnull AbstractJType abstractJType) {
        return this.isAssignableFrom(abstractJType, true);
    }

    protected boolean isAssignableFrom(@Nonnull AbstractJType abstractJType, boolean bl) {
        if (this.isError() || abstractJType.isError()) {
            return false;
        }
        if (this.equals(abstractJType)) {
            return true;
        }
        if (this.isReference() && abstractJType.isReference()) {
            AbstractJClass abstractJClass = (AbstractJClass)this;
            AbstractJClass abstractJClass2 = (AbstractJClass)abstractJType;
            if (abstractJClass2 instanceof JNullType) {
                return true;
            }
            if (abstractJClass == abstractJClass._package().owner().ref(Object.class)) {
                return true;
            }
            if (this.isArray() && abstractJType.isArray()) {
                return this.elementType().isAssignableFrom(abstractJType.elementType(), false);
            }
            if (abstractJClass.erasure().equals(abstractJClass2.erasure())) {
                if (!abstractJClass.isParameterized()) {
                    return true;
                }
                if (!abstractJClass2.isParameterized()) {
                    return bl;
                }
                for (int i = 0; i < abstractJClass.getTypeParameters().size(); ++i) {
                    AbstractJClass abstractJClass3 = abstractJClass.getTypeParameters().get(i);
                    AbstractJClass abstractJClass4 = abstractJClass2.getTypeParameters().get(i);
                    if (abstractJClass3 instanceof JTypeWildcard) {
                        JTypeWildcard jTypeWildcard = (JTypeWildcard)abstractJClass3;
                        if (abstractJClass4 instanceof JTypeWildcard) {
                            JTypeWildcard jTypeWildcard2 = (JTypeWildcard)abstractJClass4;
                            if (jTypeWildcard.boundMode() != jTypeWildcard2.boundMode()) {
                                return false;
                            }
                            if (jTypeWildcard.boundMode() == JTypeWildcard.EBoundMode.EXTENDS) {
                                return jTypeWildcard.bound().isAssignableFrom(jTypeWildcard2.bound(), false);
                            }
                            if (jTypeWildcard.boundMode() == JTypeWildcard.EBoundMode.SUPER) {
                                return jTypeWildcard2.bound().isAssignableFrom(jTypeWildcard.bound(), false);
                            }
                            throw new IllegalStateException("Unsupported wildcard bound mode: " + (Object)((Object)jTypeWildcard.boundMode()));
                        }
                        if (jTypeWildcard.boundMode() == JTypeWildcard.EBoundMode.EXTENDS) {
                            return jTypeWildcard.bound().isAssignableFrom(abstractJClass4, false);
                        }
                        if (jTypeWildcard.boundMode() == JTypeWildcard.EBoundMode.SUPER) {
                            return abstractJClass4.isAssignableFrom(jTypeWildcard.bound(), false);
                        }
                        throw new IllegalStateException("Unsupported wildcard bound mode: " + (Object)((Object)jTypeWildcard.boundMode()));
                    }
                    if (abstractJClass3.equals(abstractJClass4)) continue;
                    return false;
                }
                return true;
            }
            AbstractJClass abstractJClass5 = abstractJClass2._extends();
            if (abstractJClass5 != null && this.isAssignableFrom(abstractJClass5)) {
                return true;
            }
            Iterator<AbstractJClass> iterator = abstractJClass2._implements();
            while (iterator.hasNext()) {
                AbstractJClass abstractJClass6 = iterator.next();
                if (!this.isAssignableFrom(abstractJClass6)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fullName() + ')';
    }
}

