/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JArray
extends AbstractJExpressionImpl {
    private final AbstractJType m_aType;
    private final IJExpression m_aSize;
    private List<IJExpression> m_aExprs;

    protected JArray(@Nonnull AbstractJType abstractJType, @Nullable IJExpression iJExpression) {
        this.m_aType = abstractJType;
        this.m_aSize = iJExpression;
    }

    @Nonnull
    public AbstractJType type() {
        return this.m_aType;
    }

    @Nullable
    public IJExpression size() {
        return this.m_aSize;
    }

    @Nonnull
    public JArray add(@Nonnull IJExpression iJExpression) {
        if (this.m_aExprs == null) {
            this.m_aExprs = new ArrayList<IJExpression>();
        }
        this.m_aExprs.add(iJExpression);
        return this;
    }

    @Nonnull
    public JArray removeAll() {
        this.m_aExprs = null;
        return this;
    }

    @Nonnull
    public List<IJExpression> exprs() {
        if (this.m_aExprs == null) {
            this.m_aExprs = new ArrayList<IJExpression>();
        }
        return Collections.unmodifiableList(this.m_aExprs);
    }

    public boolean hasExprs() {
        return this.m_aExprs != null && !this.m_aExprs.isEmpty();
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        int n = 0;
        AbstractJType abstractJType = this.m_aType;
        boolean bl = this.hasExprs();
        while (abstractJType.isArray()) {
            abstractJType = abstractJType.elementType();
            ++n;
        }
        jFormatter.print("new").generable(abstractJType).print('[');
        if (this.m_aSize != null) {
            jFormatter.generable(this.m_aSize);
        }
        jFormatter.print(']');
        for (int i = 0; i < n; ++i) {
            jFormatter.print("[]");
        }
        if (this.m_aSize == null || bl) {
            jFormatter.print('{');
        }
        if (bl) {
            jFormatter.generable(this.m_aExprs);
        } else {
            jFormatter.print(' ');
        }
        if (this.m_aSize == null || bl) {
            jFormatter.print('}');
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JArray jArray = (JArray)object;
        return JCEqualsHelper.isEqual(this.m_aType.fullName(), jArray.m_aType.fullName()) && JCEqualsHelper.isEqual(this.m_aSize, jArray.m_aSize) && JCEqualsHelper.isEqual(this.m_aExprs, jArray.m_aExprs);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aType.fullName(), this.m_aSize, this.m_aExprs);
    }
}

