/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionAssignmentTargetImpl;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JArrayCompRef
extends AbstractJExpressionAssignmentTargetImpl {
    private final IJExpression _array;
    private final IJExpression _index;

    protected JArrayCompRef(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        if (iJExpression == null || iJExpression2 == null) {
            throw new NullPointerException();
        }
        this._array = iJExpression;
        this._index = iJExpression2;
    }

    @Nonnull
    public IJExpression array() {
        return this._array;
    }

    @Nonnull
    public IJExpression index() {
        return this._index;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.generable(this._array).print('[').generable(this._index).print(']');
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JArrayCompRef jArrayCompRef = (JArrayCompRef)object;
        return JCEqualsHelper.isEqual(this._array, jArrayCompRef._array) && JCEqualsHelper.isEqual(this._index, jArrayCompRef._index);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this._array, this._index);
    }
}

