/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJClassContainer;
import com.helger.jcodemodel.AbstractJGenerifiableImpl;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAnnotationWriter;
import com.helger.jcodemodel.IJClassContainer;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.TypedAnnotationWriter;
import com.helger.jcodemodel.util.ClassNameComparator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JDefinedClass
extends AbstractJClassContainer<JDefinedClass>
implements IJDeclaration,
IJGenerifiable,
IJAnnotatable,
IJDocCommentable {
    private JDocComment m_aHeaderComment;
    private JMods m_aMods;
    private AbstractJClass m_aSuperClass;
    private final Set<AbstractJClass> m_aInterfaces = new TreeSet<AbstractJClass>(ClassNameComparator.getInstance());
    final Map<String, JFieldVar> m_aFields = new LinkedHashMap<String, JFieldVar>();
    private JBlock m_aStaticInit;
    private JBlock m_aInstanceInit;
    private JDocComment m_aJDoc;
    private final List<JMethod> m_aConstructors = new ArrayList<JMethod>();
    private final List<JMethod> m_aMethods = new ArrayList<JMethod>();
    private boolean m_bHideFile = false;
    @Deprecated
    public Object metadata;
    private String m_sDirectBlock;
    private final Map<String, JEnumConstant> m_aEnumConstantsByName = new LinkedHashMap<String, JEnumConstant>();
    private List<JAnnotationUse> m_aAnnotations;
    private final AbstractJGenerifiableImpl m_aGenerifiable = new AbstractJGenerifiableImpl(){

        @Override
        @Nonnull
        public JCodeModel owner() {
            return JDefinedClass.this.owner();
        }
    };

    protected JDefinedClass(@Nonnull IJClassContainer<?> iJClassContainer, int n, @Nullable String string, @Nonnull EClassType eClassType) {
        this(iJClassContainer.owner(), iJClassContainer, n, eClassType, string);
    }

    protected JDefinedClass(@Nonnull JCodeModel jCodeModel, int n, @Nullable String string) {
        this(jCodeModel, null, n, EClassType.CLASS, string);
    }

    private JDefinedClass(@Nonnull JCodeModel jCodeModel, @Nullable IJClassContainer<?> iJClassContainer, int n, @Nonnull EClassType eClassType, @Nullable String string) {
        super(jCodeModel, iJClassContainer, eClassType, string);
        if (string != null) {
            if (string.trim().length() == 0) {
                throw new IllegalArgumentException("JDefinedClass name empty");
            }
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                String string2 = "JDefinedClass name " + string + " contains illegal character" + " for beginning of identifier: " + string.charAt(0);
                throw new IllegalArgumentException(string2);
            }
            for (int i = 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                String string3 = "JDefinedClass name " + string + " contains illegal character " + c;
                throw new IllegalArgumentException(string3);
            }
        }
        this.m_aMods = this.isInterface() ? JMods.forInterface(n) : JMods.forClass(n);
    }

    @Nonnull
    public JMods mods() {
        return this.m_aMods;
    }

    @Nonnull
    public JDefinedClass _extends(@Nonnull AbstractJClass abstractJClass) {
        if (this.isInterface()) {
            if (abstractJClass.isInterface()) {
                return this._implements(abstractJClass);
            }
            throw new IllegalArgumentException("unable to set the super class for an interface");
        }
        if (abstractJClass == null) {
            throw new NullPointerException();
        }
        for (AbstractJClass abstractJClass2 = abstractJClass.outer(); abstractJClass2 != null; abstractJClass2 = abstractJClass2.outer()) {
            if (this != abstractJClass2) continue;
            throw new IllegalArgumentException("Illegal class inheritance loop.  Outer class " + this.name() + " may not subclass from inner class: " + abstractJClass2.name());
        }
        this.m_aSuperClass = abstractJClass;
        return this;
    }

    @Nonnull
    public JDefinedClass _extends(@Nonnull Class<?> clazz) {
        return this._extends(this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public AbstractJClass _extends() {
        if (this.m_aSuperClass == null) {
            this.m_aSuperClass = this.owner().ref(Object.class);
        }
        return this.m_aSuperClass;
    }

    @Nonnull
    public JDefinedClass _implements(@Nonnull AbstractJClass abstractJClass) {
        this.m_aInterfaces.add(abstractJClass);
        return this;
    }

    @Nonnull
    public JDefinedClass _implements(@Nonnull Class<?> clazz) {
        return this._implements(this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public Iterator<AbstractJClass> _implements() {
        return this.m_aInterfaces.iterator();
    }

    @Nonnull
    public JEnumConstant enumConstant(@Nonnull String string) {
        JEnumConstant jEnumConstant = this.m_aEnumConstantsByName.get(string);
        if (null == jEnumConstant) {
            jEnumConstant = new JEnumConstant(this, string);
            this.m_aEnumConstantsByName.put(string, jEnumConstant);
        }
        return jEnumConstant;
    }

    @Override
    public String binaryName() {
        if (this.getOuter() instanceof AbstractJClassContainer) {
            return ((AbstractJClassContainer)this.getOuter()).binaryName() + '$' + this.name();
        }
        return this.fullName();
    }

    @Override
    public boolean isAbstract() {
        return this.m_aMods.isAbstract();
    }

    public JFieldVar field(int n, AbstractJType abstractJType, String string) {
        return this.field(n, abstractJType, string, null);
    }

    public JFieldVar field(int n, Class<?> clazz, String string) {
        return this.field(n, this.owner()._ref(clazz), string);
    }

    @Nonnull
    public JFieldVar field(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        JFieldVar jFieldVar = new JFieldVar(this, JMods.forField(n), abstractJType, string, iJExpression);
        if (this.m_aFields.containsKey(string)) {
            throw new IllegalArgumentException("trying to create the same field twice: " + string);
        }
        this.m_aFields.put(string, jFieldVar);
        return jFieldVar;
    }

    @Nonnull
    public JFieldVar field(int n, Class<?> clazz, String string, IJExpression iJExpression) {
        return this.field(n, this.owner()._ref(clazz), string, iJExpression);
    }

    @Nonnull
    public Map<String, JFieldVar> fields() {
        return Collections.unmodifiableMap(this.m_aFields);
    }

    public void removeField(@Nonnull JFieldVar jFieldVar) {
        if (this.m_aFields.remove(jFieldVar.name()) != jFieldVar) {
            throw new IllegalArgumentException();
        }
    }

    public boolean containsField(@Nullable String string) {
        return string != null && this.m_aFields.containsKey(string);
    }

    @Nonnull
    public JBlock init() {
        if (this.m_aStaticInit == null) {
            this.m_aStaticInit = new JBlock();
        }
        return this.m_aStaticInit;
    }

    @Nonnull
    public JBlock instanceInit() {
        if (this.m_aInstanceInit == null) {
            this.m_aInstanceInit = new JBlock();
        }
        return this.m_aInstanceInit;
    }

    @Nonnull
    public JMethod constructor(int n) {
        JMethod jMethod = new JMethod(n, this);
        this.m_aConstructors.add(jMethod);
        return jMethod;
    }

    @Nonnull
    public Iterator<JMethod> constructors() {
        return this.m_aConstructors.iterator();
    }

    @Nullable
    public JMethod getConstructor(@Nonnull AbstractJType[] abstractJTypeArray) {
        for (JMethod jMethod : this.m_aConstructors) {
            if (!jMethod.hasSignature(abstractJTypeArray)) continue;
            return jMethod;
        }
        return null;
    }

    @Nonnull
    public JMethod method(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string) {
        JMethod jMethod = new JMethod(this, n, abstractJType, string);
        this.m_aMethods.add(jMethod);
        return jMethod;
    }

    @Nonnull
    public JMethod method(int n, Class<?> clazz, String string) {
        return this.method(n, this.owner()._ref(clazz), string);
    }

    @Nonnull
    public Collection<JMethod> methods() {
        return this.m_aMethods;
    }

    @Nullable
    public JMethod getMethod(String string, AbstractJType[] abstractJTypeArray) {
        for (JMethod jMethod : this.m_aMethods) {
            if (!jMethod.name().equals(string) || !jMethod.hasSignature(abstractJTypeArray)) continue;
            return jMethod;
        }
        return null;
    }

    public boolean hasHeaderComment() {
        return this.m_aHeaderComment != null;
    }

    @Nonnull
    public JDocComment headerComment() {
        if (this.m_aHeaderComment == null) {
            this.m_aHeaderComment = new JDocComment(this.owner());
        }
        return this.m_aHeaderComment;
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJDoc == null) {
            this.m_aJDoc = new JDocComment(this.owner());
        }
        return this.m_aJDoc;
    }

    public void hide() {
        this.m_bHideFile = true;
    }

    public boolean isHidden() {
        return this.m_bHideFile;
    }

    @Override
    public void declare(@Nonnull JFormatter jFormatter) {
        if (this.m_aJDoc != null) {
            jFormatter.newline().generable(this.m_aJDoc);
        }
        if (this.m_aAnnotations != null) {
            for (JAnnotationUse jAnnotationUse : this.m_aAnnotations) {
                jFormatter.generable(jAnnotationUse).newline();
            }
        }
        jFormatter.generable(this.m_aMods).print(this.getClassType().declarationToken()).id(this.name()).declaration(this.m_aGenerifiable);
        boolean bl = false;
        if (this.m_aSuperClass != null && this.m_aSuperClass != this.owner().ref(Object.class)) {
            bl = true;
            jFormatter.newline().indent().print("extends").generable(this.m_aSuperClass).newline().outdent();
        }
        if (!this.m_aInterfaces.isEmpty()) {
            if (!bl) {
                jFormatter.newline();
            }
            jFormatter.indent().print(this.isInterface() ? "extends" : "implements");
            jFormatter.generable(this.m_aInterfaces);
            jFormatter.newline().outdent();
        }
        this.declareBody(jFormatter);
    }

    protected void declareBody(@Nonnull JFormatter jFormatter) {
        jFormatter.print('{').newline().indent();
        boolean bl = true;
        if (!this.m_aEnumConstantsByName.isEmpty()) {
            for (JEnumConstant iJDocCommentable : this.m_aEnumConstantsByName.values()) {
                if (bl) {
                    bl = false;
                } else {
                    jFormatter.print(',').newline();
                }
                jFormatter.declaration(iJDocCommentable);
            }
            jFormatter.print(';').newline();
        }
        for (JFieldVar jFieldVar : this.m_aFields.values()) {
            jFormatter.declaration(jFieldVar);
        }
        if (this.m_aStaticInit != null) {
            jFormatter.newline().print("static").statement(this.m_aStaticInit);
        }
        if (this.m_aInstanceInit != null) {
            jFormatter.newline().statement(this.m_aInstanceInit);
        }
        for (JMethod jMethod : this.m_aConstructors) {
            jFormatter.newline().declaration(jMethod);
        }
        for (JMethod jMethod : this.m_aMethods) {
            jFormatter.newline().declaration(jMethod);
        }
        if (this.m_aClasses != null) {
            for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
                jFormatter.newline().declaration(jDefinedClass);
            }
        }
        if (this.m_sDirectBlock != null) {
            jFormatter.print(this.m_sDirectBlock);
        }
        jFormatter.outdent().print('}').newline();
    }

    public void direct(@Nullable String string) {
        if (this.m_sDirectBlock == null) {
            this.m_sDirectBlock = string;
        } else if (string != null) {
            this.m_sDirectBlock = this.m_sDirectBlock + string;
        }
    }

    @Override
    @Nonnull
    public final JPackage _package() {
        IJClassContainer<?> iJClassContainer = this.getOuter();
        while (!(iJClassContainer instanceof JPackage)) {
            iJClassContainer = iJClassContainer.parentContainer();
        }
        return (JPackage)iJClassContainer;
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string) {
        return this.m_aGenerifiable.generify(string);
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string, @Nonnull Class<?> clazz) {
        return this.m_aGenerifiable.generify(string, clazz);
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string, @Nonnull AbstractJClass abstractJClass) {
        return this.m_aGenerifiable.generify(string, abstractJClass);
    }

    @Override
    @Nonnull
    public JTypeVar[] typeParams() {
        return this.m_aGenerifiable.typeParams();
    }

    @Override
    @Nonnull
    public List<JTypeVar> typeParamList() {
        return this.m_aGenerifiable.typeParamList();
    }

    @Override
    protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
        return this;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public <W extends IJAnnotationWriter<?>> W annotate2(@Nonnull Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableCollection(this.m_aAnnotations);
    }

    @Nullable
    public JAnnotationUse getAnnotation(Class<?> clazz) {
        for (JAnnotationUse jAnnotationUse : this.m_aAnnotations) {
            String string;
            AbstractJClass abstractJClass = jAnnotationUse.getAnnotationClass();
            if (abstractJClass.isError() || (string = abstractJClass.fullName()) == null || !string.equals(clazz.getName())) continue;
            return jAnnotationUse;
        }
        return null;
    }

    @Override
    @Nonnull
    protected JDefinedClass createInnerClass(int n, EClassType eClassType, String string) {
        return new JDefinedClass(this, n, string, eClassType);
    }

    public boolean containsErrorTypes() {
        return JFormatter.containsErrorTypes(this);
    }
}

