/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.util.JCNameUtilities;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class JReferencedClass
extends AbstractJClass
implements IJDeclaration {
    private final Class<?> m_aClass;

    JReferencedClass(@Nonnull JCodeModel jCodeModel, @Nonnull Class<?> clazz) {
        super(jCodeModel);
        this.m_aClass = clazz;
        assert (!this.m_aClass.isArray());
    }

    @Override
    public String name() {
        return this.m_aClass.getSimpleName();
    }

    @Override
    @Nonnull
    public String fullName() {
        return JCNameUtilities.getFullName(this.m_aClass);
    }

    @Override
    public String binaryName() {
        return this.m_aClass.getName();
    }

    @Override
    public AbstractJClass outer() {
        Class<?> clazz = this.m_aClass.getDeclaringClass();
        if (clazz == null) {
            return null;
        }
        return this.owner().ref(clazz);
    }

    @Override
    @Nonnull
    public JPackage _package() {
        String string = this.fullName();
        if (string.indexOf(91) != -1) {
            return this.owner()._package("");
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return this.owner()._package("");
        }
        return this.owner()._package(string.substring(0, n));
    }

    @Override
    public AbstractJClass _extends() {
        Class<?> clazz = this.m_aClass.getSuperclass();
        if (clazz == null) {
            if (this.isInterface()) {
                return this.owner().ref(Object.class);
            }
            return null;
        }
        return this.owner().ref(clazz);
    }

    @Override
    public Iterator<AbstractJClass> _implements() {
        final Class[] classArray = this.m_aClass.getInterfaces();
        return new Iterator<AbstractJClass>(){
            private int m_nIdx = 0;

            @Override
            public boolean hasNext() {
                return this.m_nIdx < classArray.length;
            }

            @Override
            @Nonnull
            public AbstractJClass next() {
                return JReferencedClass.this.owner().ref(classArray[this.m_nIdx++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isInterface() {
        return this.m_aClass.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.m_aClass.getModifiers());
    }

    @Override
    @Nullable
    public JPrimitiveType getPrimitiveType() {
        Class<?> clazz = JCodeModel.boxToPrimitive.get(this.m_aClass);
        if (clazz != null) {
            return AbstractJType.parse(this.owner(), clazz.getName());
        }
        return null;
    }

    @Override
    public void declare(JFormatter jFormatter) {
    }

    @Override
    public JTypeVar[] typeParams() {
        return super.typeParams();
    }

    @Override
    protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
        return this;
    }
}

