/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JOp;
import javax.annotation.Nonnull;

public class JWhileLoop
implements IJStatement {
    private final IJExpression m_aTextExpr;
    private JBlock m_aBody;

    protected JWhileLoop(@Nonnull IJExpression iJExpression) {
        this.m_aTextExpr = iJExpression;
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTextExpr;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        if (JOp.hasTopOp(this.m_aTextExpr)) {
            jFormatter.print("while ").generable(this.m_aTextExpr);
        } else {
            jFormatter.print("while (").generable(this.m_aTextExpr).print(')');
        }
        if (this.m_aBody != null) {
            jFormatter.statement(this.m_aBody);
        } else {
            jFormatter.print(';').newline();
        }
    }
}

