/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.render;

import java.io.Serializable;
import java.io.Writer;
import org.mulesoft.common.core.package;
import org.mulesoft.common.core.package$;
import org.yaml.model.YDocument;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YNode;
import org.yaml.model.YScalar;
import org.yaml.model.YSequence;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import org.yaml.model.YValue;
import org.yaml.render.JsonRender$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001%\u0011!BS:p]J+g\u000eZ3s\u0015\t\u0019A!\u0001\u0004sK:$WM\u001d\u0006\u0003\u000b\u0019\tA!_1nY*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0006\u0004%IAE\u0001\bEVLG\u000eZ3s+\u0005\u0019\u0002C\u0001\u000b\u001a\u001b\u0005)\"B\u0001\f\u0018\u0003\tIwNC\u0001\u0019\u0003\u0011Q\u0017M^1\n\u0005i)\"AB,sSR,'\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u0014\u0003!\u0011W/\u001b7eKJ\u0004\u0003\"\u0002\u0010\u0001\t\u0013y\u0012A\u0002\u001fj]&$h\b\u0006\u0002!EA\u0011\u0011\u0005A\u0007\u0002\u0005!)\u0011#\ba\u0001'!)A\u0005\u0001C!K\u0005AAo\\*ue&tw\rF\u0001'!\t9cF\u0004\u0002)YA\u0011\u0011\u0006D\u0007\u0002U)\u00111\u0006C\u0001\u0007yI|w\u000e\u001e \n\u00055b\u0011A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0007\t\u000fI\u0002\u0001\u0019!C\u0005g\u0005Y\u0011N\u001c3f]R\fG/[8o+\u0005!\u0004CA\u00066\u0013\t1DBA\u0002J]RDq\u0001\u000f\u0001A\u0002\u0013%\u0011(A\bj]\u0012,g\u000e^1uS>tw\fJ3r)\tQT\b\u0005\u0002\fw%\u0011A\b\u0004\u0002\u0005+:LG\u000fC\u0004?o\u0005\u0005\t\u0019\u0001\u001b\u0002\u0007a$\u0013\u0007\u0003\u0004A\u0001\u0001\u0006K\u0001N\u0001\rS:$WM\u001c;bi&|g\u000e\t\u0005\u0006\u0005\u0002!IaQ\u0001\u0007S:$WM\u001c;\u0015\u0003iBQ!\u0012\u0001\u0005\n\r\u000ba\u0001Z3eK:$\b\"B$\u0001\t\u0013A\u0015\u0001\u0004:f]\u0012,'/\u00138eK:$H#\u0001\u0011\t\u000b\r\u0001A\u0011\u0002&\u0015\u0005\u0001Z\u0005\"\u0002'J\u0001\u0004i\u0015\u0001\u00028pI\u0016\u0004\"AT)\u000e\u0003=S!\u0001\u0015\u0003\u0002\u000b5|G-\u001a7\n\u0005I{%!B-O_\u0012,\u0007\"\u0002+\u0001\t\u0013)\u0016!\u0003:f]\u0012,'oU3r)\t\u0001c\u000bC\u0003X'\u0002\u0007\u0001,A\u0002tKF\u0004\"AT-\n\u0005i{%!C-TKF,XM\\2f\u0011\u0015a\u0006\u0001\"\u0003^\u0003%\u0011XM\u001c3fe6\u000b\u0007\u000f\u0006\u0002!=\")ql\u0017a\u0001A\u0006\u0019Q.\u00199\u0011\u00059\u000b\u0017B\u00012P\u0005\u0011IV*\u00199\t\u000b\u0011\u0004A\u0011B3\u0002\u0019I,g\u000eZ3s'\u000e\fG.\u0019:\u0015\u0007i27\u000eC\u0003hG\u0002\u0007\u0001.A\u0001u!\tq\u0015.\u0003\u0002k\u001f\n)\u0011\fV=qK\")An\u0019a\u0001[\u000611oY1mCJ\u0004\"A\u00148\n\u0005=|%aB-TG\u0006d\u0017M\u001d\u0005\u0006\u0007\u0001!I!\u001d\u000b\u0003AIDQa\u001d9A\u0002\u0019\nQA^1mk\u0016<Q!\u001e\u0002\t\u0002Y\f!BS:p]J+g\u000eZ3s!\t\tsOB\u0003\u0002\u0005!\u0005\u0001p\u0005\u0002x\u0015!)ad\u001eC\u0001uR\ta\u000fC\u0003\u0004o\u0012\u0005A\u0010\u0006\u0003\u0014{\u0006\u0015\u0001\"\u0002@|\u0001\u0004y\u0018a\u00013pGB\u0019a*!\u0001\n\u0007\u0005\rqJA\u0005Z\t>\u001cW/\\3oi\"1\u0011qA>A\u0002M\taa\u001e:ji\u0016\u0014\bBB\u0002x\t\u0003\tY\u0001F\u0002'\u0003\u001bAaA`A\u0005\u0001\u0004y\b")
public class JsonRender {
    private final Writer builder;
    private int indentation;

    public static String render(YDocument yDocument) {
        return JsonRender$.MODULE$.render(yDocument);
    }

    public static Writer render(YDocument yDocument, Writer writer) {
        return JsonRender$.MODULE$.render(yDocument, writer);
    }

    private Writer builder() {
        return this.builder;
    }

    public String toString() {
        return this.builder().toString();
    }

    private int indentation() {
        return this.indentation;
    }

    private void indentation_$eq(int x$1) {
        this.indentation = x$1;
    }

    private void indent() {
        this.indentation_$eq(this.indentation() + 2);
    }

    private void dedent() {
        this.indentation_$eq(this.indentation() - 2);
    }

    private JsonRender renderIndent() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.indentation()).foreach((Function1 & Serializable & scala.Serializable)_ -> JsonRender.$anonfun$renderIndent$1(this, BoxesRunTime.unboxToInt((Object)_)));
        return this;
    }

    public JsonRender org$yaml$render$JsonRender$$render(YNode node) {
        JsonRender jsonRender;
        YValue yValue = node.value();
        if (yValue instanceof YMap) {
            YMap yMap = (YMap)yValue;
            jsonRender = this.renderMap(yMap);
        } else if (yValue instanceof YSequence) {
            YSequence ySequence = (YSequence)yValue;
            jsonRender = this.renderSeq(ySequence);
        } else if (yValue instanceof YScalar) {
            YScalar yScalar = (YScalar)yValue;
            this.renderScalar(node.tagType(), yScalar);
            jsonRender = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)yValue);
        }
        return this;
    }

    private JsonRender renderSeq(YSequence seq) {
        JsonRender jsonRender;
        if (seq.isEmpty()) {
            jsonRender = this.org$yaml$render$JsonRender$$render("[]");
        } else {
            this.org$yaml$render$JsonRender$$render("[\n");
            this.indent();
            int total = seq.nodes().size();
            for (int c = 0; c < total; ++c) {
                YNode node = (YNode)seq.nodes().apply(c);
                this.renderIndent().org$yaml$render$JsonRender$$render(node);
                JsonRender jsonRender2 = c < total - 1 ? this.org$yaml$render$JsonRender$$render(",\n") : this.org$yaml$render$JsonRender$$render("\n");
            }
            this.dedent();
            jsonRender = this.renderIndent().org$yaml$render$JsonRender$$render("]");
        }
        return jsonRender;
    }

    private JsonRender renderMap(YMap map) {
        JsonRender jsonRender;
        if (map.isEmpty()) {
            jsonRender = this.org$yaml$render$JsonRender$$render("{}");
        } else {
            this.org$yaml$render$JsonRender$$render("{\n");
            this.indent();
            int total = map.entries().size();
            for (int c = 0; c < total; ++c) {
                YMapEntry entry = (YMapEntry)map.entries().apply(c);
                this.renderIndent().org$yaml$render$JsonRender$$render(entry.key()).org$yaml$render$JsonRender$$render(": ").org$yaml$render$JsonRender$$render(entry.value());
                JsonRender jsonRender2 = c < total - 1 ? this.org$yaml$render$JsonRender$$render(",\n") : this.org$yaml$render$JsonRender$$render("\n");
            }
            this.dedent();
            jsonRender = this.renderIndent().org$yaml$render$JsonRender$$render("}");
        }
        return jsonRender;
    }

    private void renderScalar(YType t, YScalar scalar) {
        String string;
        boolean bl;
        YType yType = t;
        YType yType2 = YType$.MODULE$.Int();
        YType yType3 = yType;
        if (!(yType2 != null ? !yType2.equals(yType3) : yType3 != null)) {
            bl = true;
        } else {
            YType yType4 = YType$.MODULE$.Bool();
            YType yType5 = yType;
            bl = !(yType4 != null ? !yType4.equals(yType5) : yType5 != null);
        }
        if (bl) {
            string = scalar.value().toString();
        } else {
            YType yType6 = YType$.MODULE$.Float();
            YType yType7 = yType;
            if (!(yType6 != null ? !yType6.equals(yType7) : yType7 != null)) {
                String s = scalar.value().toString();
                string = s.indexOf(46) == -1 ? s + ".0" : s;
            } else {
                YType yType8 = YType$.MODULE$.Null();
                YType yType9 = yType;
                string = !(yType8 != null ? !yType8.equals(yType9) : yType9 != null) ? "null" : '\"' + package.Strings$.MODULE$.encode$extension(package$.MODULE$.Strings(scalar.text())) + '\"';
            }
        }
        this.org$yaml$render$JsonRender$$render(string);
    }

    public JsonRender org$yaml$render$JsonRender$$render(String value) {
        this.builder().append(value);
        return this;
    }

    public static final /* synthetic */ Writer $anonfun$renderIndent$1(JsonRender $this, int _) {
        return $this.builder().append(' ');
    }

    public JsonRender(Writer builder) {
        this.builder = builder;
        this.indentation = 0;
    }
}

