/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.render;

import java.io.StringWriter;
import org.mulesoft.common.io.Output;
import org.mulesoft.common.io.Output$;
import org.yaml.lexer.YamlCharRules$;
import org.yaml.model.YPart;
import org.yaml.model.YScalar;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import org.yaml.render.YamlRender;
import org.yaml.render.YamlRender$CharQuotedScalarRules$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class YamlRender$ {
    public static YamlRender$ MODULE$;

    static {
        new YamlRender$();
    }

    public <W> void render(W writer, Seq<YPart> parts, Output<W> evidence$2) {
        this.render(writer, parts, false, evidence$2);
    }

    public <W> void render(W writer, Seq<YPart> parts, boolean expandReferences, Output<W> evidence$3) {
        new YamlRender<W>(writer, expandReferences, evidence$3).renderParts(parts);
    }

    public <W> void render(W writer, YPart part, Output<W> evidence$4) {
        this.render(part, false);
    }

    public <W> void render(W writer, YPart part, boolean expandReferences, Output<W> evidence$5) {
        this.render(writer, (Seq<YPart>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new YPart[]{part}))), expandReferences, evidence$5);
    }

    public String render(Seq<YPart> parts) {
        return this.render(parts, false);
    }

    public String render(Seq<YPart> parts, boolean expandReferences) {
        StringWriter s = new StringWriter();
        this.render(s, parts, expandReferences, Output$.MODULE$.outputWriter());
        return s.toString();
    }

    public String render(YPart part) {
        return this.render(part, false);
    }

    public String render(YPart part, boolean expandReferences) {
        StringWriter s = new StringWriter();
        this.render(s, part, expandReferences, Output$.MODULE$.outputWriter());
        return s.toString();
    }

    public final int QuotedScalar() {
        return 1;
    }

    public final int PlainScalar() {
        return 2;
    }

    public final int LiteralScalar() {
        return 3;
    }

    public int org$yaml$render$YamlRender$$analyzeScalar(YScalar scalar, Option<YType> yType) {
        String text = scalar.text();
        int l = text.length();
        if (l == 0) {
            return scalar.plain() ? 2 : 1;
        }
        if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).head()) == ' ' || text.endsWith("\n\n")) {
            return 1;
        }
        if (yType.contains((Object)YType$.MODULE$.Str()) && (scalar.text().matches("^-?\\d+(?:[,|\\.]\\d+)?$") || scalar.text().matches("true|false"))) {
            return 1;
        }
        boolean oneLine = true;
        boolean allSpaces = true;
        boolean noTabs = true;
        boolean flowChar = false;
        YamlRender.ScalarIterator iterator = new YamlRender.ScalarIterator(text);
        do {
            char c = iterator.current();
            switch (c) {
                case '\n': {
                    oneLine = false;
                    break;
                }
                case '\t': {
                    noTabs = false;
                    break;
                }
                case '\r': {
                    return 1;
                }
                default: {
                    if (!YamlCharRules$.MODULE$.isCPrintable(iterator.current())) {
                        return 1;
                    }
                    if (YamlRender$CharQuotedScalarRules$.MODULE$.apply(iterator)) {
                        flowChar = true;
                        break;
                    }
                    allSpaces = false;
                    break;
                }
            }
        } while (iterator.advance());
        return oneLine ? (flowChar ? 1 : (scalar.plain() && noTabs && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).last()) != ' ' ? 2 : 1)) : (allSpaces ? 1 : 3);
    }

    private Option<YType> analyzeScalar$default$2() {
        return None$.MODULE$;
    }

    private YamlRender$() {
        MODULE$ = this;
    }
}

