/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.render;

import org.mulesoft.common.core.package;
import org.mulesoft.common.core.package$;
import org.yaml.lexer.YamlCharRules$;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import org.yaml.parser.ScalarParser;
import org.yaml.parser.ScalarParser$;
import org.yaml.render.ScalarRender;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ScalarRender$ {
    public static ScalarRender$ MODULE$;

    static {
        new ScalarRender$();
    }

    public final int QuotedScalar() {
        return 1;
    }

    public final int PlainScalar() {
        return 2;
    }

    public final int LiteralScalar() {
        return 3;
    }

    public CharSequence renderScalar(String text, boolean mustBeString, boolean plain, int indentation, String firstLineComment, boolean isCoreSchema) {
        CharSequence charSequence;
        int n = this.analyzeScalar(text, plain, mustBeString, isCoreSchema);
        switch (n) {
            case 2: {
                charSequence = text;
                break;
            }
            case 1: {
                charSequence = new java.lang.StringBuilder(11).append('\"').append(package.Strings$.MODULE$.encode$extension(package$.MODULE$.Strings(text))).append('\"').toString();
                break;
            }
            case 3: {
                charSequence = this.renderAsLiteral(text, firstLineComment, indentation);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return charSequence;
    }

    public boolean renderScalar$default$2() {
        return true;
    }

    public boolean renderScalar$default$3() {
        return true;
    }

    public int renderScalar$default$4() {
        return 0;
    }

    public String renderScalar$default$5() {
        return "";
    }

    public boolean renderScalar$default$6() {
        return true;
    }

    private CharSequence renderAsLiteral(String text, String firstLineComment, int indentation) {
        StringBuilder builder = new StringBuilder();
        int ind = indentation < 0 ? 2 : indentation + 2;
        builder.$plus$eq('|');
        int l = text.length();
        Object object = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).head()) == ' ' ? builder.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger((int)ind)).toString()) : BoxedUnit.UNIT;
        Object object2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), l - 1) != '\n' ? builder.$plus$eq('-') : (l > 1 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), l - 2) == '\n' ? builder.$plus$eq('+') : BoxedUnit.UNIT);
        builder.$plus$plus$eq(firstLineComment);
        int start = 0;
        int end = 0;
        do {
            BoxedUnit boxedUnit;
            String str = (end = text.indexOf(10, start)) == -1 ? text.substring(start) : text.substring(start, end);
            builder.$plus$eq('\n');
            if (new StringOps(Predef$.MODULE$.augmentString(str)).nonEmpty()) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ind).foreach((Function1 & java.io.Serializable & Serializable)_ -> builder.$plus$eq(' '));
                boxedUnit = builder.$plus$plus$eq(str);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            start = end + 1;
        } while (end != -1);
        return builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int analyzeScalar(String text, boolean plain, boolean mustBeString, boolean isCoreSchema) {
        int l = text.length();
        if (l == 0) {
            if (mustBeString) return 1;
            if (plain) return 2;
            return 1;
        }
        if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).head()) == ' ') return 1;
        if (text.endsWith("\n\n")) {
            return 1;
        }
        boolean oneLine = true;
        boolean allSpaces = true;
        boolean noTabs = true;
        boolean flowChar = false;
        ScalarRender.ScalarIterator iterator = new ScalarRender.ScalarIterator(text);
        do {
            char c = iterator.current();
            switch (c) {
                case '\n': {
                    oneLine = false;
                    break;
                }
                case '\t': {
                    noTabs = false;
                    break;
                }
                case '\r': {
                    return 1;
                }
                default: {
                    if (!YamlCharRules$.MODULE$.isCPrintable(iterator.current())) {
                        return 1;
                    }
                    if (iterator.shouldQuote()) {
                        flowChar = true;
                        break;
                    }
                    allSpaces = false;
                    break;
                }
            }
        } while (iterator.advance());
        if (oneLine) {
            if (flowChar) {
                return 1;
            }
            if (!plain) return 1;
            if (!noTabs) return 1;
            if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).last()) == ' ') return 1;
            if (!mustBeString) {
                return 2;
            }
            ScalarParser sp = ScalarParser$.MODULE$.apply(text);
            sp.parse();
            YType yType = sp.ytype();
            YType yType2 = YType$.MODULE$.Str();
            if (yType == null) {
                if (yType2 == null) return 2;
            } else if (yType.equals(yType2)) return 2;
            if (!isCoreSchema) return 1;
            YType yType3 = sp.ytype();
            YType yType4 = YType$.MODULE$.Timestamp();
            if (yType3 != null) {
                if (!yType3.equals(yType4)) return 1;
                return 2;
            }
            if (yType4 == null) return 2;
            return 1;
        }
        if (!allSpaces) return 3;
        return 1;
    }

    public boolean analyzeScalar$default$4() {
        return true;
    }

    private ScalarRender$() {
        MODULE$ = this;
    }
}

