/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.util.Preconditions;

public class ResolverSet
implements ValueResolver<ResolverSetResult> {
    private Map<Parameter, ValueResolver> resolvers = new LinkedHashMap<Parameter, ValueResolver>();
    private boolean dynamic = false;

    public ResolverSet add(Parameter parameter, ValueResolver resolver) {
        Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (String)"parameter cannot be null");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        this.resolvers.put(parameter, resolver);
        if (resolver.isDynamic()) {
            this.dynamic = true;
        }
        return this;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public ResolverSetResult resolve(MuleEvent event) throws MuleException {
        ResolverSetResult.Builder builder = ResolverSetResult.newBuilder();
        for (Map.Entry<Parameter, ValueResolver> entry : this.resolvers.entrySet()) {
            builder.add(entry.getKey(), entry.getValue().resolve(event));
        }
        return builder.build();
    }

    public Map<Parameter, ValueResolver> getResolvers() {
        return ImmutableMap.copyOf(this.resolvers);
    }
}

