/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.mule.AsyncSynchronizeListener;
import org.mule.BatchSynchronizeListener;
import org.mule.PipelineSynchronizeListener;
import org.mule.SynchronizeProber;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.tck.probe.Probe;

public abstract class Synchronizer {
    private MuleContext muleContext;
    private long timeout;

    public Synchronizer(MuleContext muleContext, long timeout) {
        this.muleContext = muleContext;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent runAndWait(MuleEvent event) throws Exception {
        final AsyncSynchronizeListener asyncListener = new AsyncSynchronizeListener();
        final PipelineSynchronizeListener pipelineListener = new PipelineSynchronizeListener();
        final BatchSynchronizeListener batchListener = new BatchSynchronizeListener();
        this.muleContext.registerListener((ServerNotificationListener)asyncListener);
        this.muleContext.registerListener((ServerNotificationListener)pipelineListener);
        this.muleContext.registerListener((ServerNotificationListener)batchListener);
        MuleEvent returnObject = this.process(event);
        try {
            new SynchronizeProber(this.timeout, 100L).check(new Probe(){

                public boolean isSatisfied() {
                    return asyncListener.readyToContinue() && pipelineListener.readyToContinue() && batchListener.readyToContinue();
                }

                public String describeFailure() {
                    return "Time out waiting for async executions";
                }
            });
        }
        finally {
            this.muleContext.unregisterListener((ServerNotificationListener)asyncListener);
            this.muleContext.unregisterListener((ServerNotificationListener)pipelineListener);
            this.muleContext.unregisterListener((ServerNotificationListener)batchListener);
        }
        return returnObject;
    }

    protected abstract MuleEvent process(MuleEvent var1) throws Exception;
}

