
# Anypoint Template: MUnit testing of Batch Module in the Salesforce to Salesforce and Database Account Broadcast template

This application illustrates how to using MUnit mocks to test the Batch Module through an example of integrating Salesforce to Salesforce and Database.


### Assumptions ###

This document assumes that you are familiar with Mule and the [Anypoint Studio interface](http://www.mulesoft.org/documentation/display/current/Anypoint+Studio+Essentials). To increase your familiarity with Studio, consider completing one or more [Anypoint Studio Tutorials](http://www.mulesoft.org/documentation/display/current/Basic+Studio+Tutorial). Further, this example assumes that you have a basic understanding of [Mule flows](http://www.mulesoft.org/documentation/display/current/Mule+Application+Architecture), [Mule Global Elements](http://www.mulesoft.org/documentation/display/current/Global+Elements), Scatter Gather component [Scatter Gather](http://www.mulesoft.org/documentation/display/current/scatter-gather) and the [MUnit](https://docs.mulesoft.com/mule-user-guide/v/3.7/munit).
This document describes the details of the example within the context of Anypoint Studio, Mule ESBs graphical user interface.


### Use Case ###
This application synchronize accounts from a Salesforce Org to another Salesforce Org and a Database.
The application also shows you how to use [MUnit](https://docs.mulesoft.com/mule-user-guide/v/3.7/munit) to test the solution using mocks.

As implemented, this Anypoint Template leverages the [Batch Module](http://www.mulesoft.org/documentation/display/current/Batch+Processing).
The batch job is divided into Input, Process and On Complete stages.

The integration can be triggered in two different ways: by a poll defined in the endpoints file or by an outbound notification generated by Salesforce. Either way, the application queries/receives newest Salesforce updates/creations matching a filter criteria and adds them to a JMS topic.
The application has two different batch jobs consuming this JMS topic, one for migrating the changes to the second Salesforce Org and the other one for migrating the changes to the Database. During the Process stage, each Salesforce account will be matched with an existing account in the Salesforce Org B or the Database by Name. The last step of the Process stage will group the accounts and create/update them in Salesforce Org B.

Finally during the On Complete stage the Anypoint Template will log output statistics data into the console.


# Considerations

To make this Anypoint Template run, there are certain preconditions that must be considered. All of them deal with the preparations in both source and destination systems, that must be made in order for all to run smoothly. **Failling to do so could lead to unexpected behavior of the template.**

## DB Considerations

There may be a few things that you need to know regarding DB, in order for this template to work.

This Anypoint Template may be using date time/timestamp fields from the DB in order to do comparisons and take further actions.
While the template handles the time zone by sending all such fields in a neutral time zone, it can not handle **time offsets**.
We define as **time offsets** the time difference that may surface between date time/timestamp fields from different systems due to a differences in the system's internal clock.
The user of this template should take this in consideration and take the actions needed to avoid the time offset.


### DB as destination of data

There are no particular considerations for this Anypoint Template regarding DB as data destination.

## Salesforce Considerations 

There may be a few things that you need to know regarding Salesforce, in order for this template to work.

In order to have this template working as expected, you should be aware of your own Salesforce field configuration.


### Application Configuration ###

To make the application run, it's required to configure the different end points involved. The configuration files is located for the chosen environment in the [src/main/resources/mule.env.properties]
The following is an example to show you what vales are expected from the user during the configuration. 
To run the MUnit tests, the configuration file is located in the [src/test/resources/mule.test.properties]

+ http.port `9090` 
+ poll.frequencyMillis `60000`
+ poll.startDelayMillis `0`
+ watermark.defaultExpression `YESTERDAY`
+ trigger.policy `push` | `poll`

**Note**: the property `trigger.policy` can assume only one of the values above either *push* or *poll*

**Database Connector configuration**

+ database.url `jdbc:mysql://localhost:3306/mule?user=mule&password=mule`

If it is required to connect to a different Database there should be provided the jar for the library and changed the value of that field in the connector.

**Salesforce Connector configuration for company A**

+ sfdc.a.username `bob.dylan@orga`
+ sfdc.a.password `DylanPassword123`
+ sfdc.a.securityToken `avsfwCUl7apQs56Xq2AKi3X`
+ sfdc.a.url `https://login.salesforce.com/services/Soap/u/32.0`

**Salesforce Connector configuration for company B**

+ sfdc.b.username `joan.baez@orgb`
+ sfdc.b.password `JoanBaez456`
+ sfdc.b.securityToken `ces56arl7apQs56XTddf34X`
+ sfdc.b.url `https://login.salesforce.com/services/Soap/u/32.0`

### Additional MUnit configuration
**Test only**
+ database.url `jdbc:h2:mem:test;MODE=MySQL;USER=;PASSWORD=`
+ database.driver `org.h2.Driver`


# API Calls <a name="apicalls"/>
Salesforce imposes limits on the number of API Calls that can be made. Therefore calculating this amount may be an important factor to consider. The Anypoint Template calls to the API can be calculated using the formula:

***1 + X + X / 200***

Being ***X*** the number of Accounts to be synchronized on each run. 

The division by ***200*** is because, by default, Accounts are gathered in groups of 200 for each Upsert API Call in the commit step. Also consider that this calls are executed repeatedly every polling cycle.	

For instance if 10 records are fetched from origin instance, then 12 api calls will be made (1 + 10 + 1).

### How it Works ###
The application is structured in the several files based on the functional aspect.


## config.xml
Configuration for Connectors and [Properties Place Holders](http://www.mulesoft.org/documentation/display/current/Configuring+Properties) are set in this file. **Even you can change the configuration here, all parameters that can be modified here are in properties file, and this is the recommended place to do it so.** Of course if you want to do core changes to the logic you will probably need to modify this file.

In the visual editor they can be found on the *Global Element* tab.


## businessLogic.xml
A functional aspect of this Anypoint Template implemented in this XML is to create or update objects in the destination system for a represented use case. You can customize and extend the logic of this Anypoint Template in this XML to more specifically meet your needs.


## endpoints.xml
This is file is conformed by a two Flows.

The first one we'll call it **push** flow. This one contains an HTTP endpoint that will be listening for notifications from Salesforce . Each of them will be processed and thus update/create Accounts, and then executing the batch job process.

The second one we'll call it **poll** flow. This one contains the Poll endpoint that will periodically query Salesforce for updated/created Accounts that meet the defined criteria in the query, and then executing the batch job process.

The property **trigger.policy** is the one in charge of defining from which endpoint the Template will recieve the data. The property can only assume one of two values `push` or `poll` any other value will result in the Template ignoring all messages.


## errorHandling.xml
This is the right place to handle how your integration will react depending on the different exceptions. 
This file holds a [Choice Exception Strategy](http://www.mulesoft.org/documentation/display/current/Choice+Exception+Strategy) that is referenced by the main flow in the business logic.


## endpoints-test-suite.xml
The [MUnit](https://docs.mulesoft.com/mule-user-guide/v/3.7/munit) tests covering the endpoints behavior are implemented on this XML file.


## businessLogic-test-suite.xml
This file contains the [MUnit](https://docs.mulesoft.com/mule-user-guide/v/3.7/munit) tests covering the business logic. For testing we are using mocks to simulate the real world behavior of the application.