/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.mule.module.twilio.ITwilioRestClient;

public class TwilioRestClient
implements ITwilioRestClient {
    public static final String TWILIO_URL = "https://api.twilio.com";
    private String endpoint = "https://api.twilio.com";
    private String accountSid;
    private String authToken;

    public TwilioRestClient(String accountSid, String authToken, String endpoint) {
        this.accountSid = accountSid;
        this.authToken = authToken;
        if (endpoint != null && !endpoint.equals("")) {
            this.endpoint = endpoint;
        }
    }

    @Override
    public TwilioRestResponse request(String path, String method, Map<String, String> vars) throws TwilioRestException {
        String encoded = "";
        if (vars != null && !vars.isEmpty()) {
            for (String key : vars.keySet()) {
                try {
                    encoded = encoded + "&" + key + "=" + URLEncoder.encode(vars.get(key), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new TwilioRestException(e);
                }
            }
            encoded = encoded.substring(1);
        }
        String url = this.endpoint + path;
        if (method.toUpperCase().equals("GET")) {
            url = url + (path.indexOf(63) == -1 ? "?" : "&") + encoded;
        }
        try {
            String line;
            BufferedReader in;
            HttpURLConnection con;
            block21: {
                OutputStreamWriter out;
                con = this.openConnection(url);
                String userpass = this.accountSid + ":" + this.authToken;
                String encodeuserpass = new String(Base64.encodeBase64((byte[])userpass.getBytes()));
                con.setRequestProperty("Authorization", "Basic " + encodeuserpass);
                con.setDoOutput(true);
                if (method.toUpperCase().equals("GET")) {
                    con.setRequestMethod("GET");
                } else if (method.toUpperCase().equals("POST")) {
                    con.setRequestMethod("POST");
                    out = new OutputStreamWriter(con.getOutputStream());
                    out.write(encoded);
                    out.close();
                } else if (method.toUpperCase().equals("PUT")) {
                    con.setRequestMethod("PUT");
                    out = new OutputStreamWriter(con.getOutputStream());
                    out.write(encoded);
                    out.close();
                } else if (method.toUpperCase().equals("DELETE")) {
                    con.setRequestMethod("DELETE");
                } else {
                    throw new TwilioRestException("Unknown method " + method);
                }
                in = null;
                try {
                    if (con.getInputStream() != null) {
                        in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    }
                }
                catch (IOException e) {
                    if (con.getErrorStream() == null) break block21;
                    in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                }
            }
            if (in == null) {
                throw new TwilioRestException("Unable to read response from server");
            }
            StringBuilder decodedString = new StringBuilder();
            while ((line = in.readLine()) != null) {
                decodedString.append(line);
            }
            in.close();
            int responseCode = con.getResponseCode();
            return new TwilioRestResponse(url, decodedString.toString(), responseCode);
        }
        catch (MalformedURLException e) {
            throw new TwilioRestException(e);
        }
        catch (IOException e) {
            throw new TwilioRestException(e);
        }
    }

    protected HttpURLConnection openConnection(String url) throws IOException {
        URL resturl = new URL(url);
        return (HttpURLConnection)resturl.openConnection();
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public void setAccountSid(String accountSid) {
        this.accountSid = accountSid;
    }
}

