/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.twilio;

import org.mule.api.callback.HttpCallback;
import org.mule.module.twilio.AccountStatus;
import org.mule.module.twilio.HttpMethod;
import org.mule.module.twilio.RecordingType;
import org.mule.module.twilio.TranscriptionFormat;
import org.mule.module.twilio.TwilioParameters;
import org.mule.module.twilio.TwilioRequestExecutor;

public class TwilioClient {
    public static final String PATH_PREFIX = "/2010-04-01";
    private static final String ACCOUNT_URI = "/2010-04-01/Accounts/";
    private static final HttpMethod DEFAULT_CALLBACK_HTTP_METHOD = HttpMethod.GET;
    private TwilioRequestExecutor twilioRequestExecutor;
    private String accountSid;

    public TwilioClient(String accountSid, String authToken) {
        this.accountSid = accountSid;
        this.twilioRequestExecutor = new TwilioRequestExecutor(accountSid, authToken);
    }

    public String getAccountDetails(String accountSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid));
    }

    public String getAllAcountsDetails(String friendlyName, AccountStatus accountStatus) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS, (Object)accountStatus);
        return this.twilioRequestExecutor.executeGetRequest(ACCOUNT_URI, optionalParams);
    }

    public String updateAccount(String accountSid, AccountStatus accountStatus, String friendlyName) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS, (Object)accountStatus);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid), optionalParams);
    }

    public String createSubAccount(String friendlyName) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        return this.twilioRequestExecutor.executePostRequest(ACCOUNT_URI, optionalParams);
    }

    public String getSubAccountBySid(String accountSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid));
    }

    public String getSubAccountByFriendlyName(String friendlyName) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        return this.twilioRequestExecutor.executeGetRequest(ACCOUNT_URI, requiredParams);
    }

    public String exchangePhoneNumbersBetweenSubaccounts(String accountSidFrom, String incomingPhoneNumberSid, String accountSidTo) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.ACCOUNT_SID, accountSidTo);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSidFrom) + "/IncomingPhoneNumbers/" + incomingPhoneNumberSid, requiredParams);
    }

    public String getAvailablePhoneNumbers(String accountSid, String isoCountryCode, String areaCode, String contains, String inRegion, String inPostalCode) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL);
        this.addBasicSearchParams(areaCode, contains, inRegion, inPostalCode, optionalParams);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/AvailablePhoneNumbers/" + isoCountryCode + "/Local", optionalParams);
    }

    public String getAvailablePhoneNumbersAdvancedSeach(String accountSid, String isoCountryCode, String areaCode, String contains, String inRegion, String inPostalCode, String nearLatLong, String nearPhoneNumber, String inLata, String inRateCenter, String distance) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL);
        this.addBasicSearchParams(areaCode, contains, inRegion, inPostalCode, optionalParams);
        optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.NEAR_LAT_LONG, nearLatLong).addIfValueNotNull(TwilioParameters.TwilioParamater.NEAR_NUMBER, nearPhoneNumber).addIfValueNotNull(TwilioParameters.TwilioParamater.IN_LATA, inLata).addIfValueNotNull(TwilioParameters.TwilioParamater.IN_RATE_CENTER, inRateCenter).addIfValueNotNull(TwilioParameters.TwilioParamater.DISTANCE, distance);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/AvailablePhoneNumbers/" + isoCountryCode + "/Local", optionalParams);
    }

    public String getAvailableTollFreeNumbers(String accountSid, String isoCountryCode, String contains) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.CONTAINS, contains);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/AvailablePhoneNumbers/" + isoCountryCode + "/TollFree", optionalParams);
    }

    public String getOutgoingCallerIdByOutgoingCallerIdSid(String accountSid, String outgoingCallerIdSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/OutgoingCallerIds/" + outgoingCallerIdSid);
    }

    public String updateOutgoingCallerIdByOutgoingCallerIdSid(String accountSid, String outgoingCallerIdSid, String friendlyName) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/OutgoingCallerIds/" + outgoingCallerIdSid, requiredParams);
    }

    public String getAllOutgoingCallerIds(String accountSid, String phoneNumber, String friendlyName) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.PHONE_NUMBER, phoneNumber).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/OutgoingCallerIds/", optionalParams);
    }

    public String addNewCallerId(String accountSid, String phoneNumber, String friendlyName, Integer callDelay, String extension) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.PHONE_NUMBER, phoneNumber);
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.CALL_DELAY, callDelay).addIfValueNotNull(TwilioParameters.TwilioParamater.EXTENSION, extension);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/OutgoingCallerIds/", requiredParams, optionalParams);
    }

    public String deleteOutgoingCallerId(String accountSid, String outgoingCallerIdSid) {
        return this.twilioRequestExecutor.executeDeleteRequest(this.getUri(accountSid) + "/OutgoingCallerIds/" + outgoingCallerIdSid);
    }

    public String getIncomingPhoneNumbers(String accountSid, String incomingPhoneNumberSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/IncomingPhoneNumbers/" + incomingPhoneNumberSid);
    }

    public String updateIncomingPhoneNumbers(String accountSid, String incomingPhoneNumberSid, String friendlyName, String apiVersion, String voiceUrl, HttpMethod voiceMethod, HttpCallback voiceFallback, HttpCallback statusCallback, Boolean voiceCallerIdLookup, String voiceApplicationSid, String smsUrl, HttpMethod smsMethod, HttpCallback smsFallback, String smsApplicationSid, String accountSidDestination) {
        TwilioParameters twilioParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.AT_LEAST_ONE_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.API_VERSION, apiVersion).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_URL, voiceUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_METHOD, (Object)voiceMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD).addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_CALLER_ID_LOOKUP, voiceCallerIdLookup).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_APPLICATION_SID, voiceApplicationSid).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_URL, smsUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_METHOD, (Object)smsMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_APPLICATION_SID, smsApplicationSid).addIfValueNotNull(TwilioParameters.TwilioParamater.ACCOUNT_SID, accountSidDestination);
        if (voiceFallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_URL, voiceFallback.getUrl());
        }
        if (statusCallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
        }
        if (smsFallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_URL, smsFallback.getUrl());
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/IncomingPhoneNumbers/" + incomingPhoneNumberSid, twilioParams);
    }

    public String deleteIncomingPhoneNumber(String accountSid, String incomingPhoneNumberSid) {
        return this.twilioRequestExecutor.executeDeleteRequest(this.getUri(accountSid) + "/IncomingPhoneNumbers/" + incomingPhoneNumberSid);
    }

    public String getIncomingPhoneNumbers(String accountSid, String phoneNumber, String friendlyName) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.PHONE_NUMBER, phoneNumber).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/IncomingPhoneNumbers", optionalParams);
    }

    public String addIncomingPhoneNumberByPhoneNumber(String accountSid, String phoneNumber, String friendlyName, String voiceUrl, HttpMethod voiceMethod, HttpCallback voiceFallback, HttpCallback statusCallback, Boolean voiceCallerIdLookup, String voiceApplicationSid, String smsUrl, HttpMethod smsMethod, HttpCallback smsFallback, String smsApplicationSid) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.PHONE_NUMBER, phoneNumber);
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_URL, voiceUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_METHOD, (Object)voiceMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_CALLER_ID_LOOKUP, voiceCallerIdLookup).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_APPLICATION_SID, voiceApplicationSid).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_URL, smsUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_METHOD, (Object)smsMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_APPLICATION_SID, smsApplicationSid);
        if (statusCallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (voiceFallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_URL, voiceFallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (smsFallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_URL, smsFallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/IncomingPhoneNumbers", requiredParams, optionalParams);
    }

    public String addIncomingPhoneNumberByAreaCode(String accountSid, String areaCode, String friendlyName, String voiceUrl, HttpMethod voiceMethod, HttpCallback voiceFallback, HttpCallback statusCallback, Boolean voiceCallerIdLookup, String voiceApplicationSid, String smsUrl, HttpMethod smsMethod, HttpCallback smsFallback, String smsApplicationSid) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.AREA_CODE, areaCode);
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_URL, voiceUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_METHOD, (Object)voiceMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_CALLER_ID_LOOKUP, voiceCallerIdLookup).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_APPLICATION_SID, voiceApplicationSid).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_URL, smsUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_METHOD, (Object)smsMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_APPLICATION_SID, smsApplicationSid);
        if (statusCallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (voiceFallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_URL, voiceFallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (smsFallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_URL, smsFallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/IncomingPhoneNumbers", requiredParams, optionalParams);
    }

    public String getApplication(String accountSid, String applicationSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Applications/" + applicationSid);
    }

    public String updateApplication(String accountSid, String applicationSid, String friendlyName, String apiVersion, String voiceUrl, HttpMethod voiceMethod, HttpCallback voiceFallback, HttpCallback statusCallback, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, HttpCallback smsFallback, HttpCallback smsStatusCallback) {
        TwilioParameters twilioParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.AT_LEAST_ONE_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.API_VERSION, apiVersion).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_URL, voiceUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_METHOD, (Object)voiceMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_CALLER_ID_LOOKUP, voiceCallerIdLookup).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_URL, smsUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_METHOD, (Object)smsMethod);
        if (statusCallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (voiceFallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_URL, voiceFallback.getUrl());
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (smsFallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_URL, smsFallback.getUrl());
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (smsStatusCallback != null) {
            twilioParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_STATUS_CALLBACK, smsStatusCallback.getUrl());
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/Applications/" + applicationSid, twilioParams);
    }

    public String deleteApplication(String accountSid, String applicationSid) {
        return this.twilioRequestExecutor.executeDeleteRequest(this.getUri(accountSid) + "/Applications/" + applicationSid);
    }

    public String getAllApplications(String accountSid, String friendlyName) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Applications", optionalParams);
    }

    public String createApplication(String accountSid, String friendlyName, String apiVersion, String voiceUrl, HttpMethod voiceMethod, HttpCallback voiceFallback, HttpCallback statusCallback, Boolean voiceCallerIdLookup, String smsUrl, HttpMethod smsMethod, HttpCallback smsFallback, HttpCallback smsStatusCallback) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName);
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.API_VERSION, apiVersion).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_URL, voiceUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_METHOD, (Object)voiceMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_CALLER_ID_LOOKUP, voiceCallerIdLookup).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_URL, smsUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_METHOD, (Object)smsMethod);
        if (smsStatusCallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_STATUS_CALLBACK, smsStatusCallback.getUrl());
        }
        if (statusCallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (voiceFallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_URL, voiceFallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (smsFallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_URL, smsFallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/Applications/", requiredParams, optionalParams);
    }

    public String getCall(String accountSid, String callSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Calls/" + callSid);
    }

    public String getCalls(String accountSid, String to, String from, String status, String startTime) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.TO, to).addIfValueNotNull(TwilioParameters.TwilioParamater.FROM, from).addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS, status).addIfValueNotNull(TwilioParameters.TwilioParamater.START_TIME, startTime);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Calls/", optionalParams);
    }

    public String makeCall(String accountSid, String from, String to, String url, String applicationSid, HttpMethod method, HttpCallback fallback, HttpCallback statusCallback, String sendDigits, String ifMachine, String timeout) {
        TwilioParameters toFromParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.TO, to).addIfValueNotNull(TwilioParameters.TwilioParamater.FROM, from);
        TwilioParameters urlOrApplicationSidParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.EXACTLY_ONE_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.URL, url).addIfValueNotNull(TwilioParameters.TwilioParamater.APPLICATION_SID, applicationSid);
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.METHOD, (Object)method).addIfValueNotNull(TwilioParameters.TwilioParamater.SEND_DIGITS, sendDigits).addIfValueNotNull(TwilioParameters.TwilioParamater.IF_MACHINE, ifMachine).addIfValueNotNull(TwilioParameters.TwilioParamater.TIMEOUT, timeout);
        if (fallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.FALLBACK_URL, fallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.FALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        if (statusCallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK_METHOD, (Object)DEFAULT_CALLBACK_HTTP_METHOD);
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/Calls/", toFromParams, urlOrApplicationSidParams, optionalParams);
    }

    public String changeCallState(String accountSid, String callSid, String url, HttpMethod method, String status) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.URL, url).addIfValueNotNull(TwilioParameters.TwilioParamater.METHOD, (Object)method).addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS, status);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/Calls/" + callSid, optionalParams);
    }

    public String getConference(String accountSid, String conferenceSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Conferences/" + conferenceSid);
    }

    public String getConferences(String accountSid, String status, String friendlyName, String dateCreated, String dateUpdated) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS, status).addIfValueNotNull(TwilioParameters.TwilioParamater.FRIENDLY_NAME, friendlyName).addIfValueNotNull(TwilioParameters.TwilioParamater.DATE_CREATED, dateCreated).addIfValueNotNull(TwilioParameters.TwilioParamater.DATE_UPDATED, dateUpdated);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Conferences/", optionalParams);
    }

    public String getParticipant(String accountSid, String conferenceSid, String callSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Conferences/" + conferenceSid + "/Participants/" + callSid);
    }

    public String updateParticipantStauts(String accountSid, String conferenceSid, String callSid, Boolean muted) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.MUTED, muted);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/Conferences/" + conferenceSid + "/Participants/" + callSid, requiredParams);
    }

    public String deleteParticipant(String accountSid, String conferenceSid, String callSid) {
        return this.twilioRequestExecutor.executeDeleteRequest(this.getUri(accountSid) + "/Conferences/" + conferenceSid + "/Participants/" + callSid);
    }

    public String getParticipants(String accountSid, String conferenceSid, Boolean muted) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.MUTED, muted);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Conferences/" + conferenceSid + "/Participants/", optionalParams);
    }

    public String getSmsMessage(String accountSid, String smsMessageSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/SMS/Messages/" + smsMessageSid);
    }

    public String getAllSmsMessages(String accountSid, String to, String from, String dateSent) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.TO, to).addIfValueNotNull(TwilioParameters.TwilioParamater.FROM, from).addIfValueNotNull(TwilioParameters.TwilioParamater.DATE_SENT, dateSent);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/SMS/Messages/", optionalParams);
    }

    public String sendSmsMessage(String accountSid, String from, String to, String body, HttpCallback statusCallback, String applicationSid) {
        TwilioParameters requiredParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_REQUIRED).addIfValueNotNull(TwilioParameters.TwilioParamater.FROM, from).addIfValueNotNull(TwilioParameters.TwilioParamater.TO, to).addIfValueNotNull(TwilioParameters.TwilioParamater.BODY, body);
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.APPLICATION_SID, applicationSid);
        if (statusCallback != null) {
            optionalParams.addIfValueNotNull(TwilioParameters.TwilioParamater.STATUS_CALLBACK, statusCallback.getUrl());
        }
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/SMS/Messages/", requiredParams, optionalParams);
    }

    public String getRecording(String accountSid, String recordingSid, RecordingType recordingType) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Recordings/" + recordingSid + recordingType.getExtension());
    }

    public String deleteRecording(String accountSid, String recordingSid) {
        return this.twilioRequestExecutor.executeDeleteRequest(this.getUri(accountSid) + "/Recordings/" + recordingSid);
    }

    public String getRecordings(String accountSid, String callSid, String dateCreated) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.CALL_SID, callSid).addIfValueNotNull(TwilioParameters.TwilioParamater.DATE_CREATED, dateCreated);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Recordings/", optionalParams);
    }

    public String getTranscriptionByTranscriptionSid(String accountSid, String transcriptionSid, TranscriptionFormat transcriptionFormat) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Transcriptions/" + transcriptionSid + transcriptionFormat.getExtension());
    }

    public String getTranscriptions(String accountSid, String recordingSid, TranscriptionFormat transcriptionFormat) {
        if (recordingSid == null) {
            return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Transcriptions");
        }
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Recordings/" + recordingSid + transcriptionFormat.getExtension());
    }

    public String getNotification(String accountSid, String notificationSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Notifications/" + notificationSid);
    }

    public String deleteNotification(String accountSid, String notificationSid) {
        return this.twilioRequestExecutor.executeDeleteRequest(this.getUri(accountSid) + "/Notifications/" + notificationSid);
    }

    public String getAllNotifications(String accountSid, Integer log, String messageDate) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.LOG, log).addIfValueNotNull(TwilioParameters.TwilioParamater.MESSAGE_DATE, messageDate);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Notifications/", optionalParams);
    }

    public String getNotifications(String accountSid, String callSid, Integer log, String messageDate) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.LOG, log).addIfValueNotNull(TwilioParameters.TwilioParamater.MESSAGE_DATE, messageDate);
        return this.twilioRequestExecutor.executeGetRequest(this.getUri(accountSid) + "/Calls/" + callSid + "/Notifications/", optionalParams);
    }

    public String getSandbox(String accountSid) {
        return this.twilioRequestExecutor.executeGetRequestNoParams(this.getUri(accountSid) + "/Sandbox");
    }

    public String updateSandbox(String accountSid, String voiceUrl, HttpMethod voiceMethod, String smsUrl, HttpMethod smsMethod) {
        TwilioParameters optionalParams = new TwilioParameters(TwilioParameters.TwilioParametersStategy.ALL_OPTIONAL).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_URL, voiceUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.VOICE_METHOD, (Object)voiceMethod).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_URL, smsUrl).addIfValueNotNull(TwilioParameters.TwilioParamater.SMS_METHOD, (Object)smsMethod);
        return this.twilioRequestExecutor.executePostRequest(this.getUri(accountSid) + "/Sandbox", optionalParams);
    }

    private void addBasicSearchParams(String areaCode, String contains, String inRegion, String inPostalCode, TwilioParameters twilioParameters) {
        twilioParameters.addIfValueNotNull(TwilioParameters.TwilioParamater.AREA_CODE, areaCode);
        twilioParameters.addIfValueNotNull(TwilioParameters.TwilioParamater.CONTAINS, contains);
        twilioParameters.addIfValueNotNull(TwilioParameters.TwilioParamater.IN_REGION, inRegion);
        twilioParameters.addIfValueNotNull(TwilioParameters.TwilioParamater.IN_POSTAL_CODE, inPostalCode);
    }

    private String getUri(String accountSid) {
        if (accountSid == null) {
            return ACCOUNT_URI + this.accountSid;
        }
        return ACCOUNT_URI + accountSid;
    }
}

