/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.twilio;

import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.param.Optional;
import org.mule.api.callback.HttpCallback;
import org.mule.module.twilio.AccountStatus;
import org.mule.module.twilio.HttpMethod;
import org.mule.module.twilio.RecordingType;
import org.mule.module.twilio.TranscriptionFormat;
import org.mule.module.twilio.TwilioClient;

@Module(name="twilio", friendlyName="Twilio")
public class TwilioConnector {
    @Configurable
    private String accountSid;
    @Configurable
    private String authToken;
    private TwilioClient twilioClient;

    @Start
    public void createTwilioClient() {
        this.twilioClient = new TwilioClient(this.accountSid, this.authToken);
    }

    @Processor
    public String getAccountDetails(@Optional String accountSid) {
        return this.twilioClient.getAccountDetails(accountSid);
    }

    @Processor
    public String getAllAccountsDetails(@Optional AccountStatus accountStatus, @Optional String friendlyName) {
        return this.twilioClient.getAllAcountsDetails(friendlyName, accountStatus);
    }

    @Processor
    public String updateAccount(@Optional String accountSid, @Optional AccountStatus accountStatus, @Optional String friendlyName) {
        return this.twilioClient.updateAccount(accountSid, accountStatus, friendlyName);
    }

    @Processor
    public String createSubAccount(@Optional String friendlyName) {
        return this.twilioClient.createSubAccount(friendlyName);
    }

    @Processor
    public String getSubAccountByAccountSid(String accountSid) {
        return this.twilioClient.getSubAccountBySid(accountSid);
    }

    @Processor
    public String getSubAccountByFriendlyName(String friendlyName) {
        return this.twilioClient.getSubAccountByFriendlyName(friendlyName);
    }

    @Processor
    public String exchangePhoneNumbersBetweenSubaccounts(@Optional String accountSidFrom, String incomingPhoneNumberSid, String accountSidTo) {
        return this.twilioClient.exchangePhoneNumbersBetweenSubaccounts(accountSidFrom, incomingPhoneNumberSid, accountSidTo);
    }

    @Processor
    public String getAvailablePhoneNumbers(@Optional String accountSid, String isoCountryCode, @Optional String areaCode, @Optional String contains, @Optional String inRegion, @Optional String inPostalCode) {
        return this.twilioClient.getAvailablePhoneNumbers(accountSid, isoCountryCode, areaCode, contains, inRegion, inPostalCode);
    }

    @Processor
    public String getAvailablePhoneNumbersAdvancedSeach(@Optional String accountSid, String isoCountryCode, @Optional String areaCode, @Optional String contains, @Optional String inRegion, @Optional String inPostalCode, @Optional @Placement(group="Advanced") String nearLatLong, @Optional @Placement(group="Advanced") String nearPhoneNumber, @Optional @Placement(group="Advanced") String inLata, @Optional @Placement(group="Advanced") String inRateCenter, @Optional @Placement(group="Advanced") String distance) {
        return this.twilioClient.getAvailablePhoneNumbersAdvancedSeach(accountSid, isoCountryCode, areaCode, contains, inRegion, inPostalCode, nearLatLong, nearPhoneNumber, inLata, inRateCenter, distance);
    }

    @Processor
    public String getAvailableTollFreeNumbers(@Optional String accountSid, String isoCountryCode, @Optional String contains) {
        return this.twilioClient.getAvailableTollFreeNumbers(accountSid, isoCountryCode, contains);
    }

    @Processor
    public String getOutgoingCallerIdByOutgoingCallerIdSid(@Optional String accountSid, String outgoingCallerIdSid) {
        return this.twilioClient.getOutgoingCallerIdByOutgoingCallerIdSid(accountSid, outgoingCallerIdSid);
    }

    @Processor
    public String updateOutgoingCallerIdByOutgoingCallerIdSid(@Optional String accountSid, String outgoingCallerIdSid, String friendlyName) {
        return this.twilioClient.updateOutgoingCallerIdByOutgoingCallerIdSid(accountSid, outgoingCallerIdSid, friendlyName);
    }

    @Processor
    public String getAllOutgoingCallerIds(@Optional String accountSid, @Optional String phoneNumber, @Optional String friendlyName) {
        return this.twilioClient.getAllOutgoingCallerIds(accountSid, phoneNumber, friendlyName);
    }

    @Processor
    public String addNewCallerId(@Optional String accountSid, String phoneNumber, @Optional String friendlyName, @Optional Integer callDelay, @Optional String extension) {
        return this.twilioClient.addNewCallerId(accountSid, phoneNumber, friendlyName, callDelay, extension);
    }

    @Processor
    public String deleteOutgoingCallerId(@Optional String accountSid, String outgoingCallerIdSid) {
        return this.twilioClient.deleteOutgoingCallerId(accountSid, outgoingCallerIdSid);
    }

    @Processor
    public String getIncomingPhoneNumbersByIncomingPhoneNumberSid(@Optional String accountSid, String incomingPhoneNumberSid) {
        return this.twilioClient.getIncomingPhoneNumbers(accountSid, incomingPhoneNumberSid);
    }

    @Processor
    public String updateIncomingPhoneNumbers(@Optional String accountSid, String incomingPhoneNumberSid, @Optional String friendlyName, @Optional String apiVersion, @Optional @Placement(group="Voice Settings") String voiceUrl, @Optional @Placement(group="Voice Settings") HttpMethod voiceMethod, @Optional @Placement(group="Voice Settings") HttpCallback voiceFallback, @Optional @Placement(group="Voice Settings") HttpCallback statusCallback, @Optional @Placement(group="Voice Settings") Boolean voiceCallerIdLookup, @Optional @Placement(group="Voice Settings") String voiceApplicationSid, @Optional @Placement(group="SMS Settings") String smsUrl, @Optional @Placement(group="SMS Settings") HttpMethod smsMethod, @Optional @Placement(group="SMS Settings") HttpCallback smsFallback, @Optional @Placement(group="SMS Settings") String smsApplicationSid, @Optional String accountSidDestination) {
        return this.twilioClient.updateIncomingPhoneNumbers(accountSid, incomingPhoneNumberSid, friendlyName, apiVersion, voiceUrl, voiceMethod, voiceFallback, statusCallback, voiceCallerIdLookup, voiceApplicationSid, smsUrl, smsMethod, smsFallback, smsApplicationSid, accountSidDestination);
    }

    @Processor
    public String deleteIncomingPhoneNumber(@Optional String accountSid, String incomingPhoneNumberSid) {
        return this.twilioClient.deleteIncomingPhoneNumber(accountSid, incomingPhoneNumberSid);
    }

    @Processor
    public String getIncomingPhoneNumbers(@Optional String accountSid, @Optional String phoneNumber, @Optional String friendlyName) {
        return this.twilioClient.getIncomingPhoneNumbers(accountSid, phoneNumber, friendlyName);
    }

    @Processor
    public String addIncomingPhoneNumberByPhoneNumber(@Optional String accountSid, String phoneNumber, @Optional String friendlyName, @Optional @Placement(group="Voice Settings") String voiceUrl, @Optional @Placement(group="Voice Settings") HttpMethod voiceMethod, @Optional @Placement(group="Voice Settings") HttpCallback voiceFallback, @Optional @Placement(group="Voice Settings") HttpCallback statusCallback, @Optional @Placement(group="Voice Settings") Boolean voiceCallerIdLookup, @Optional @Placement(group="Voice Settings") String voiceApplicationSid, @Optional @Placement(group="SMS Settings") String smsUrl, @Optional @Placement(group="SMS Settings") HttpMethod smsMethod, @Optional @Placement(group="SMS Settings") HttpCallback smsFallback, @Optional @Placement(group="SMS Settings") String smsApplicationSid) {
        return this.twilioClient.addIncomingPhoneNumberByPhoneNumber(accountSid, phoneNumber, friendlyName, voiceUrl, voiceMethod, voiceFallback, statusCallback, voiceCallerIdLookup, voiceApplicationSid, smsUrl, smsMethod, smsFallback, smsApplicationSid);
    }

    @Processor
    public String addIncomingPhoneNumberByAreaCode(@Optional String accountSid, String areaCode, @Optional String friendlyName, @Optional @Placement(group="Voice Settings") String voiceUrl, @Optional @Placement(group="Voice Settings") HttpMethod voiceMethod, @Optional @Placement(group="Voice Settings") HttpCallback voiceFallback, @Optional @Placement(group="Voice Settings") HttpCallback statusCallback, @Optional @Placement(group="Voice Settings") Boolean voiceCallerIdLookup, @Optional @Placement(group="Voice Settings") String voiceApplicationSid, @Optional @Placement(group="SMS Settings") String smsUrl, @Optional @Placement(group="SMS Settings") HttpMethod smsMethod, @Optional @Placement(group="SMS Settings") HttpCallback smsFallback, @Optional @Placement(group="SMS Settings") String smsApplicationSid) {
        return this.twilioClient.addIncomingPhoneNumberByAreaCode(accountSid, areaCode, friendlyName, voiceUrl, voiceMethod, voiceFallback, statusCallback, voiceCallerIdLookup, voiceApplicationSid, smsUrl, smsMethod, smsFallback, smsApplicationSid);
    }

    @Processor
    public String getApplication(@Optional String accountSid, String applicationSid) {
        return this.twilioClient.getApplication(accountSid, applicationSid);
    }

    @Processor
    public String updateApplication(@Optional String accountSid, String applicationSid, @Optional String friendlyName, @Optional String apiVersion, @Optional @Placement(group="Voice Settings") String voiceUrl, @Optional @Placement(group="Voice Settings") HttpMethod voiceMethod, @Optional @Placement(group="Voice Settings") HttpCallback voiceFallback, @Optional @Placement(group="Voice Settings") HttpCallback statusCallback, @Optional @Placement(group="Voice Settings") Boolean voiceCallerIdLookup, @Optional @Placement(group="SMS Settings") String smsUrl, @Optional @Placement(group="SMS Settings") HttpMethod smsMethod, @Optional @Placement(group="SMS Settings") HttpCallback smsFallback, @Optional @Placement(group="SMS Settings") HttpCallback smsStatusCallback) {
        return this.twilioClient.updateApplication(accountSid, applicationSid, friendlyName, apiVersion, voiceUrl, voiceMethod, voiceFallback, statusCallback, voiceCallerIdLookup, smsUrl, smsMethod, smsFallback, smsStatusCallback);
    }

    @Processor
    public String deleteApplication(@Optional String accountSid, String applicationSid) {
        return this.twilioClient.deleteApplication(accountSid, applicationSid);
    }

    @Processor
    public String getAllApplications(@Optional String accountSid, @Optional String friendlyName) {
        return this.twilioClient.getAllApplications(accountSid, friendlyName);
    }

    @Processor
    public String createApplication(@Optional String accountSid, String friendlyName, @Optional String apiVersion, @Optional @Placement(group="Voice Settings") String voiceUrl, @Optional @Placement(group="Voice Settings") HttpMethod voiceMethod, @Optional @Placement(group="Voice Settings") HttpCallback voiceFallback, @Optional @Placement(group="Voice Settings") HttpCallback statusCallback, @Optional @Placement(group="Voice Settings") Boolean voiceCallerIdLookup, @Optional @Placement(group="SMS Settings") String smsUrl, @Optional @Placement(group="SMS Settings") HttpMethod smsMethod, @Optional @Placement(group="SMS Settings") HttpCallback smsFallback, @Optional @Placement(group="SMS Settings") HttpCallback smsStatusCallback) {
        return this.twilioClient.createApplication(accountSid, friendlyName, apiVersion, voiceUrl, voiceMethod, voiceFallback, statusCallback, voiceCallerIdLookup, smsUrl, smsMethod, smsFallback, smsStatusCallback);
    }

    @Processor
    public String getCall(@Optional String accountSid, String callSid) {
        return this.twilioClient.getCall(accountSid, callSid);
    }

    @Processor
    public String getCalls(@Optional String accountSid, @Optional String to, @Optional String from, @Optional String status, @Optional String startTime) {
        return this.twilioClient.getCalls(accountSid, to, from, status, startTime);
    }

    @Processor
    public String makeCall(@Optional String accountSid, String from, String to, @Optional @Placement(group="Voice Settings") String url, @Optional @Placement(group="Voice Settings") String applicationSid, @Optional @Placement(group="Voice Settings") HttpMethod method, @Optional @Placement(group="Callbacks") HttpCallback fallback, @Optional @Placement(group="Callbacks") HttpCallback statusCallback, @Optional @Placement(group="Advanced") String sendDigits, @Optional @Placement(group="Advanced") String ifMachine, @Optional @Placement(group="Advanced") String timeout) {
        return this.twilioClient.makeCall(accountSid, from, to, url, applicationSid, method, fallback, statusCallback, sendDigits, ifMachine, timeout);
    }

    @Processor
    public String changeCallState(@Optional String accountSid, String callSid, @Optional String url, @Optional HttpMethod method, @Optional String status) {
        return this.twilioClient.changeCallState(accountSid, callSid, url, method, status);
    }

    @Processor
    public String getConference(@Optional String accountSid, String conferenceSid) {
        return this.twilioClient.getConference(accountSid, conferenceSid);
    }

    @Processor
    public String getConferences(@Optional String accountSid, @Optional String status, @Optional String friendlyName, @Optional String dateCreated, @Optional String dateUpdated) {
        return this.twilioClient.getConferences(accountSid, status, friendlyName, dateCreated, dateUpdated);
    }

    @Processor
    public String getParticipant(@Optional String accountSid, String conferenceSid, String callSid) {
        return this.twilioClient.getParticipant(accountSid, conferenceSid, callSid);
    }

    @Processor
    public String updateParticipantStatus(@Optional String accountSid, String conferenceSid, String callSid, Boolean muted) {
        return this.twilioClient.updateParticipantStauts(accountSid, conferenceSid, callSid, muted);
    }

    @Processor
    public String deleteParticipant(@Optional String accountSid, String conferenceSid, String callSid) {
        return this.twilioClient.deleteParticipant(accountSid, conferenceSid, callSid);
    }

    @Processor
    public String getParticipants(@Optional String accountSid, String conferenceSid, @Optional Boolean muted) {
        return this.twilioClient.getParticipants(accountSid, conferenceSid, muted);
    }

    @Processor
    public String getSmsMessage(@Optional String accountSid, String smsMessageSid) {
        return this.twilioClient.getSmsMessage(accountSid, smsMessageSid);
    }

    @Processor
    public String getAllSmsMessages(@Optional String accountSid, @Optional String to, @Optional String from, @Optional String dateSent) {
        return this.twilioClient.getAllSmsMessages(accountSid, to, from, dateSent);
    }

    @Processor
    public String sendSmsMessage(@Optional String accountSid, String from, String to, String body, @Optional HttpCallback statusCallback, @Optional String applicationSid) {
        return this.twilioClient.sendSmsMessage(accountSid, from, to, body, statusCallback, applicationSid);
    }

    @Processor
    public String getRecording(@Optional String accountSid, String recordingSid, RecordingType recordingType) {
        return this.twilioClient.getRecording(accountSid, recordingSid, recordingType);
    }

    @Processor
    public String deleteRecording(@Optional String accountSid, String recordingSid) {
        return this.twilioClient.deleteRecording(accountSid, recordingSid);
    }

    @Processor
    public String getRecordings(@Optional String accountSid, @Optional String callSid, @Optional String dateCreated) {
        return this.twilioClient.getRecordings(accountSid, callSid, dateCreated);
    }

    @Processor
    public String getTranscriptionByTranscriptionSid(@Optional String accountSid, String transcriptionSid, TranscriptionFormat transcriptionFormat) {
        return this.twilioClient.getTranscriptionByTranscriptionSid(accountSid, transcriptionSid, transcriptionFormat);
    }

    @Processor
    public String getTranscriptions(@Optional String accountSid, @Optional String recordingSid, TranscriptionFormat transcriptionFormat) {
        return this.twilioClient.getTranscriptions(accountSid, recordingSid, transcriptionFormat);
    }

    @Processor
    public String getNotification(@Optional String accountSid, String notificationSid) {
        return this.twilioClient.getNotification(accountSid, notificationSid);
    }

    @Processor
    public String deleteNotification(@Optional String accountSid, String notificationSid) {
        return this.twilioClient.deleteNotification(accountSid, notificationSid);
    }

    @Processor
    public String getAllNotifications(@Optional String accountSid, @Optional Integer log, @Optional String messageDate) {
        return this.twilioClient.getAllNotifications(accountSid, log, messageDate);
    }

    @Processor
    public String getNotificationsByCallSid(@Optional String accountSid, String callSid, @Optional Integer log, @Optional String messageDate) {
        return this.twilioClient.getNotifications(accountSid, callSid, log, messageDate);
    }

    @Processor
    public String getSandbox(@Optional String accountSid) {
        return this.twilioClient.getSandbox(accountSid);
    }

    @Processor
    public String updateSandbox(@Optional String accountSid, @Optional String voiceUrl, @Optional HttpMethod voiceMethod, @Optional String smsUrl, @Optional HttpMethod smsMethod) {
        return this.twilioClient.updateSandbox(accountSid, voiceUrl, voiceMethod, smsUrl, smsMethod);
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public void setAccountSid(String accountSid) {
        this.accountSid = accountSid;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }
}

