/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.twilio;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mule.module.twilio.ITwilioRestClient;
import org.mule.module.twilio.TwilioConnectorException;
import org.mule.module.twilio.TwilioParameters;
import org.mule.module.twilio.TwilioRestClientFactory;

public class TwilioRequestExecutor {
    private static final Logger LOGGER = Logger.getLogger(TwilioRequestExecutor.class);
    private ITwilioRestClient twilioRestClient;

    public TwilioRequestExecutor(String accountSid, String authToken) {
        this.twilioRestClient = TwilioRestClientFactory.getClient(accountSid, authToken);
    }

    TwilioRequestExecutor(ITwilioRestClient twilioRestClient) {
        this.twilioRestClient = twilioRestClient;
    }

    public String executeGetRequestNoParams(String path) {
        return this.executeGetRequest(path, TwilioParameters.NO_PARAMETERS);
    }

    public String executeGetRequest(String path, TwilioParameters twilioParameters) {
        return this.executeRequest(path, "GET", twilioParameters.getMap());
    }

    public String executePostRequest(String path, TwilioParameters ... twilioParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (TwilioParameters eachTwilioParameters : twilioParameters) {
            if (eachTwilioParameters == null || eachTwilioParameters.getMap() == null) continue;
            parameters.putAll(eachTwilioParameters.getMap());
        }
        return this.executeRequest(path, "POST", parameters);
    }

    public String executeDeleteRequest(String path) {
        return this.executeRequest(path, "DELETE", TwilioParameters.NO_PARAMETERS.getMap());
    }

    private String executeRequest(String path, String method, Map<String, String> vars) {
        try {
            TwilioRestResponse response = this.twilioRestClient.request(path, method, vars);
            LOGGER.debug((Object)("Response from Twilio: " + response));
            if (response.isError()) {
                throw new TwilioConnectorException(response);
            }
            return response.getResponseText();
        }
        catch (TwilioRestException e) {
            throw new TwilioConnectorException(e);
        }
    }
}

