/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.twilio.adapters;

import org.apache.log4j.Logger;
import org.mule.api.adapter.HttpCallbackAdapter;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.module.twilio.adapters.TwilioConnectorProcessAdapter;
import org.mule.util.NumberUtils;

public class TwilioConnectorHttpCallbackAdapter
extends TwilioConnectorProcessAdapter
implements HttpCallbackAdapter,
Initialisable {
    private Integer localPort;
    private Integer remotePort;
    private String domain;
    private String path;
    private Connector connector;
    private static final Logger LOGGER = Logger.getLogger(TwilioConnectorHttpCallbackAdapter.class);
    private Boolean async = false;

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer value) {
        this.localPort = value;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(Integer value) {
        this.remotePort = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String value) {
        this.domain = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector value) {
        this.connector = value;
    }

    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean value) {
        this.async = value;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.localPort == null) {
            String portSystemVar = System.getProperty("http.port");
            if (NumberUtils.isDigits((String)portSystemVar)) {
                this.localPort = Integer.parseInt(portSystemVar);
            } else {
                LOGGER.warn((Object)"Environment variable 'http.port' not found, using default localPort: 8080");
                this.localPort = 8080;
            }
        }
        if (this.remotePort == null) {
            LOGGER.info((Object)"Using default remotePort: 80");
            this.remotePort = 80;
        }
        if (this.domain == null) {
            String domainSystemVar = System.getProperty("fullDomain");
            if (domainSystemVar != null) {
                this.domain = domainSystemVar;
            } else {
                LOGGER.warn((Object)"Environment variable 'fullDomain' not found, using default: localhost");
                this.domain = "localhost";
            }
        }
    }
}

