/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.twilio.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessors;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.config.spring.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.construct.Flow;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;

public class DefaultHttpCallback
implements HttpCallback {
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpCallback.class);
    private Integer localPort;
    private Integer remotePort;
    private String domain;
    private String url;
    private String localUrl;
    private MuleContext muleContext;
    private Flow callbackFlow;
    private Flow flowConstruct;
    private MessageProcessor callbackMessageProcessor;
    private String callbackPath;
    private Boolean async;
    private Connector connector;
    private MessagingExceptionHandler exceptionHandler;

    public DefaultHttpCallback(Flow callbackFlow, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async) {
        this.callbackFlow = callbackFlow;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = null;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = null;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = null;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(Flow callbackFlow, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async, Connector connector) {
        this.callbackFlow = callbackFlow;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = connector;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async, Connector connector) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = connector;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(MessageProcessor callbackMessageProcessor, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, Connector connector) {
        this.callbackMessageProcessor = callbackMessageProcessor;
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = connector;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async, Connector connector) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = connector;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, Connector connector) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = connector;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, Boolean async) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.domain = callbackDomain;
        this.async = async;
        this.connector = null;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = null;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, MessagingExceptionHandler exceptionHandler) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = null;
        this.exceptionHandler = exceptionHandler;
        this.url = this.buildUrl();
    }

    public DefaultHttpCallback(List<MessageProcessor> callbackMessageProcessors, MuleContext muleContext, String callbackDomain, Integer localPort, Integer remotePort, String callbackPath, Boolean async, MessagingExceptionHandler exceptionHandler, Connector connector) throws MuleException {
        this.callbackMessageProcessor = DefaultHttpCallback.buildChain(callbackMessageProcessors);
        this.muleContext = muleContext;
        this.localPort = localPort;
        this.domain = callbackDomain;
        this.remotePort = remotePort;
        this.callbackPath = callbackPath;
        this.async = async;
        this.connector = null;
        this.exceptionHandler = exceptionHandler;
        this.connector = connector;
        this.url = this.buildUrl();
    }

    public String getUrl() {
        return this.url;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    private String buildUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        if (!this.domain.contains("://")) {
            if (this.connector != null) {
                urlBuilder.append(this.connector.getProtocol() + "://");
            } else {
                urlBuilder.append("http://");
            }
        }
        urlBuilder.append(this.domain);
        if (this.remotePort != null && this.remotePort != 80) {
            urlBuilder.append(":");
            urlBuilder.append(this.remotePort);
        }
        urlBuilder.append("/");
        if (this.callbackPath != null) {
            urlBuilder.append(this.callbackPath);
        } else {
            urlBuilder.append(UUID.randomUUID());
        }
        return urlBuilder.toString();
    }

    private MessageProcessor wrapMessageProcessorInAsyncChain(MessageProcessor messageProcessor) throws MuleException {
        AsyncMessageProcessorsFactoryBean asyncMessageProcessorsFactoryBean = new AsyncMessageProcessorsFactoryBean();
        asyncMessageProcessorsFactoryBean.setMuleContext(this.muleContext);
        asyncMessageProcessorsFactoryBean.setMessageProcessors(Arrays.asList(messageProcessor));
        asyncMessageProcessorsFactoryBean.setProcessingStrategy((ProcessingStrategy)new AsynchronousProcessingStrategy());
        try {
            return (MessageProcessor)asyncMessageProcessorsFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new FlowConstructInvalidException((Throwable)e);
        }
    }

    private Connector createConnector() throws MuleException {
        if (this.connector != null) {
            return this.connector;
        }
        MuleRegistry muleRegistry = this.muleContext.getRegistry();
        Connector httpConnector = muleRegistry.lookupConnector("connector.http.mule.default");
        if (httpConnector != null) {
            return httpConnector;
        }
        LOGGER.error((Object)"Could not find connector with name 'connector.http.mule.default'");
        throw new DefaultMuleException("Could not find connector with name 'connector.http.mule.default'");
    }

    private InboundEndpoint createHttpInboundEndpoint() throws MuleException {
        EndpointURIEndpointBuilder inBuilder = new EndpointURIEndpointBuilder(this.localUrl, this.muleContext);
        inBuilder.setConnector(this.createConnector());
        inBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
        EndpointFactory endpointFactory = this.muleContext.getEndpointFactory();
        return endpointFactory.getInboundEndpoint((EndpointBuilder)inBuilder);
    }

    public void start() throws MuleException {
        this.localUrl = this.url.replaceFirst(this.domain, "localhost");
        this.localUrl = this.localUrl.indexOf(":" + String.valueOf(this.remotePort)) == -1 ? this.localUrl.replaceFirst("localhost", "localhost:" + String.valueOf(this.localPort)) : this.localUrl.replaceFirst(String.valueOf(this.remotePort), String.valueOf(this.localPort));
        String dynamicFlowName = String.format("DynamicFlow-%s", this.localUrl);
        this.flowConstruct = new Flow(dynamicFlowName, this.muleContext);
        this.flowConstruct.setMessageSource((MessageSource)this.createHttpInboundEndpoint());
        MessageProcessor messageProcessor = this.callbackFlow != null ? new FlowRefMessageProcessor() : this.callbackMessageProcessor;
        if (this.async.booleanValue()) {
            messageProcessor = this.wrapMessageProcessorInAsyncChain(messageProcessor);
        }
        ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        messageProcessors.add(messageProcessor);
        this.flowConstruct.setMessageProcessors(messageProcessors);
        if (this.exceptionHandler != null) {
            this.flowConstruct.setExceptionListener(this.exceptionHandler);
        }
        this.flowConstruct.initialise();
        this.flowConstruct.start();
        LOGGER.debug((Object)String.format("Created flow with http inbound endpoint listening at: %s", this.url));
    }

    public void stop() throws MuleException {
        if (this.flowConstruct != null) {
            this.flowConstruct.stop();
            this.flowConstruct.dispose();
            LOGGER.debug((Object)"Http callback flow stopped");
        }
    }

    private static MessageProcessor buildChain(List<MessageProcessor> messageProcessors) throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (MessageProcessor messageProcessor : messageProcessors) {
            if (messageProcessor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{messageProcessor});
                continue;
            }
            if (!(messageProcessor instanceof MessageProcessorBuilder)) continue;
            builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)messageProcessor});
        }
        return MessageProcessors.lifecyleAwareMessageProcessorWrapper((MessageProcessor)builder.build());
    }

    public class FlowRefMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            return DefaultHttpCallback.this.callbackFlow.process(event);
        }
    }
}

