/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.1.2.3.lib.lexical.formats;

import com.mulesoft.flatfile.1.2.3.lib.lexical.ErrorHandler;
import com.mulesoft.flatfile.1.2.3.lib.lexical.LexerBase;
import com.mulesoft.flatfile.1.2.3.lib.lexical.LexicalException;
import com.mulesoft.flatfile.1.2.3.lib.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.1.2.3.lib.lexical.WriterBase;
import com.mulesoft.flatfile.1.2.3.lib.lexical.formats.StringFormatBase;

public class RestrictedCharacterStringFormat
extends StringFormatBase {
    private final boolean[] allowedChars;
    private final boolean openEnded;

    public RestrictedCharacterStringFormat(String code, int min, int max, TypeFormatConstants.FillMode fill, boolean[] allowed, boolean open) {
        super(code, min, max, fill);
        this.allowedChars = allowed;
        this.openEnded = open;
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.STRING;
    }

    @Override
    public Object parseToken(LexerBase lexer) throws LexicalException {
        if (this.allowedChars != null) {
            StringBuilder builder = lexer.tokenBuilder();
            for (int i = 0; i < builder.length(); ++i) {
                char chr = builder.charAt(i);
                boolean invalid = false;
                if (chr >= this.allowedChars.length) {
                    invalid = !this.openEnded;
                } else if (!this.allowedChars[chr]) {
                    invalid = true;
                }
                if (!invalid) continue;
                this.invalidCharacter(chr, lexer);
                int subst = lexer.getSubstitutionChar();
                if (subst > 0) {
                    builder.setCharAt(i, (char)lexer.getSubstitutionChar());
                    continue;
                }
                if (subst != 0) continue;
                builder.deleteCharAt(i--);
            }
        }
        return lexer.token();
    }

    @Override
    public String buildToken(Object value, WriterBase writer) throws LexicalException {
        if (!(value instanceof String)) {
            writer.error(this, ErrorHandler.ErrorCondition.WRONG_TYPE, "wrong value type " + value.getClass().getName());
        }
        String text = value.toString();
        if (this.allowedChars != null) {
            for (int i = 0; i < text.length(); ++i) {
                char chr = text.charAt(i);
                boolean invalid = false;
                if (chr >= this.allowedChars.length) {
                    invalid = !this.openEnded;
                } else if (!this.allowedChars[chr]) {
                    invalid = true;
                }
                if (!invalid) continue;
                this.invalidCharacter(chr, writer);
                int subst = writer.getSubstitutionChar();
                if (subst > 0) {
                    text = text.substring(0, i) + (char)subst + text.substring(i + 1);
                    continue;
                }
                if (subst != 0) continue;
                text = text.substring(0, i) + text.substring(i + 1);
            }
        }
        return text;
    }
}

