/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import >org.mule.modules.edi.base.1.2.2.lib.EdiMetaDataBuilder;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchema;
import com.mulesoft.flatfile.1.2.3.lib.schema.SchemaJavaValues;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12Acknowledgment;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12Error;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12SchemaDefs;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;
import scala.collection.convert.WrapAsJava$;

public class X12MetaDataBuilder
extends EdiMetaDataBuilder {
    public X12MetaDataBuilder(EdiSchema schema) {
        super(schema);
    }

    private void addErrors(DynamicObjectBuilder<?> container) {
        container.addList(SchemaJavaValues.errorListKey()).ofPojo(X12Error.class);
    }

    private void addInterchangeHeader(DynamicObjectBuilder<?> container, boolean errors) {
        DynamicObjectFieldBuilder inter = container.addDynamicObjectField(SchemaJavaValues.interchangeKey());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12SchemaDefs.ISASegment().components()), (DynamicObjectBuilder<?>)inter);
        if (errors) {
            this.addErrors((DynamicObjectBuilder<?>)inter);
        }
    }

    private void addGroupHeader(DynamicObjectBuilder<?> container, boolean errors) {
        DynamicObjectFieldBuilder group = container.addDynamicObjectField(SchemaJavaValues.groupKey());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12SchemaDefs.GSSegment().components()), (DynamicObjectBuilder<?>)group);
        if (errors) {
            this.addErrors((DynamicObjectBuilder<?>)group);
        }
    }

    public void build(DynamicObjectBuilder<?> root, boolean read2, boolean use999) {
        if (read2) {
            root.addSimpleField(SchemaJavaValues.delimiterCharacters(), DataType.STRING);
            EdiSchema.Structure ackTrans = use999 ? X12Acknowledgment.trans999() : X12Acknowledgment.trans997();
            DynamicObjectBuilder ackMap = root.addList(SchemaJavaValues.functionalAcksGenerated()).ofDynamicObject(ackTrans.ident());
            this.buildStructure(ackTrans, false, ackMap);
            DynamicObjectBuilder ta1Map1 = root.addList(SchemaJavaValues.interchangeAcksGenerated()).ofDynamicObject(X12Acknowledgment.segTA1().ident());
            this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12Acknowledgment.segTA1().components()), ta1Map1);
            this.addInterchangeHeader(ta1Map1, false);
            DynamicObjectBuilder ta1Map2 = root.addList(SchemaJavaValues.interchangeAcksReceived()).ofDynamicObject(X12Acknowledgment.segTA1().ident());
            this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12Acknowledgment.segTA1().components()), ta1Map2);
            this.addInterchangeHeader(ta1Map2, false);
            this.addErrors(root);
        } else {
            DynamicObjectBuilder ta1Map = root.addList(SchemaJavaValues.interchangeAcksToSend()).ofDynamicObject(X12Acknowledgment.segTA1().ident());
            this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12Acknowledgment.segTA1().components()), ta1Map);
            this.addInterchangeHeader(ta1Map, false);
            this.addInterchangeHeader(root, false);
            this.addGroupHeader(root, false);
        }
        DynamicObjectFieldBuilder verMap = root.addDynamicObjectField(X12SchemaDefs.transactionsMap());
        this.buildStructures((DynamicObjectBuilder<?>)verMap, "v" + this.schema.ediVersion().version(), read2);
    }

    @Override
    protected void buildStructure(EdiSchema.Structure structure, boolean addErrors, DynamicObjectBuilder<?> container) {
        this.addInterchangeHeader(container, addErrors);
        this.addGroupHeader(container, addErrors);
        if (addErrors) {
            this.addErrors(container);
        }
        DynamicObjectFieldBuilder set = container.addDynamicObjectField(X12SchemaDefs.setKey());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12SchemaDefs.STSegment().components()), (DynamicObjectBuilder<?>)set);
        this.buildStructureDetails(structure, container);
    }
}

