/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12.config;

import org.mule.config.MuleManifest;
import org.mule.modules.edi.x12.config.ReadDefinitionParser;
import org.mule.modules.edi.x12.config.WriteDefinitionParser;
import org.mule.modules.edi.x12.config.X12EdiModuleConfigDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class X12EdiNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(X12EdiNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [x12-edi] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [x12-edi] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new X12EdiModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("read", (BeanDefinitionParser)new ReadDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("read", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("write", (BeanDefinitionParser)new WriteDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("write", "@Processor", ex);
        }
    }
}

