/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2;

import com.modus.common.service.AS2Service;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.ClientFacade;
import com.modus.mule.modules.as2.client.ClientFacadeFactory;
import com.modus.mule.modules.as2.client.ContentTransferEncodingEnum;
import com.modus.mule.modules.as2.client.DigestAlgorithmEnum;
import com.modus.mule.modules.as2.client.Receipt;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.DigestAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.RequestReceipt;
import com.modus.mule.modules.as2.config.ConnectorConfig;
import com.modus.mule.modules.as2.config.PartnerManagerConnectorConfig;
import com.modus.mule.modules.as2.server.ServerConfig;
import com.modus.mule.modules.as2.server.ServerFacade;
import com.modus.service.AS2ServiceImpl;
import com.mulesoft.api.b2b.B2BProvider;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.callback.SourceCallback;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.MessageFactory;

public class AS2Connector {
    private ConnectorConfig connectorConfig;
    @Inject
    private MuleContext muleContext;
    private ServerFacade as2Server;
    private ClientFacadeFactory as2ClientFactory;
    private final ConnectorContext connectorContext = new ConnectorContext();
    private static final String KEY_STORE_PATH_FRIENDLY_NAME = "Key Store Path";
    private static final String KEY_STORE_PASSWORD_FRIENDLY_NAME = "Key Store Password";

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public synchronized void receive(SourceCallback callback, String receiptSubject, Boolean requireSenderCompress, String requireSenderAs2From, String requireSenderAs2To, String keyStorePath, String keyStorePassword, Boolean suppressCmsAlgorithmProtectionAttribute, Boolean requireSenderSigns, Boolean requireSenderEncrypts, DigestAlgorithmOptionEnum preferredDigestAlgorithm, String invokeFlowBeforeSendReceipt) throws AS2ConnectorException {
        this.setB2BProvider();
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setRequireSenderAs2From(requireSenderAs2From);
        serverConfig.setRequireSenderAs2To(requireSenderAs2To);
        serverConfig.setReceiptSubject(receiptSubject);
        serverConfig.setRequireSenderSigns(requireSenderSigns);
        serverConfig.setRequireSenderEncrypts(requireSenderEncrypts);
        serverConfig.setRequireSenderCompress(requireSenderCompress);
        serverConfig.setKeyStorePath(keyStorePath);
        serverConfig.setKeyStorePassword(keyStorePassword);
        serverConfig.setPreferredDigestAlgorithm(preferredDigestAlgorithm);
        serverConfig.setHttpEndpointRef(this.connectorConfig.getHttpEndpointRef());
        serverConfig.setInvokeFlowBeforeSendReceipt(invokeFlowBeforeSendReceipt);
        serverConfig.setSuppressCmsAlgorithmProtectionAttribute(suppressCmsAlgorithmProtectionAttribute);
        this.as2Server = new ServerFacade(callback, this.muleContext, serverConfig, this.connectorContext);
        this.as2Server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent send(String messageId, String subject, String contentType, ContentTransferEncodingEnum contentTransferEncoding, String filename, Integer receiptTimeout, Boolean compress, String as2From, String as2To, String keyStorePath, String keyStorePassword, String receiptVerificationCertificateKeyStoreEntryAlias, String asyncReceiptTlsCertificateKeyStoreEntryAlias, RequestReceipt requestReceipt, Boolean sign, Boolean encrypt, Boolean suppressCmsAlgorithmProtectionAttribute, Boolean requireReceiptForUnsupportedSignatureFormat, Boolean requireReceiptForUnsupportedDigestAlgorithm, DigestAlgorithmEnum digestAlgorithm, DigestAlgorithmOptionEnum fallbackDigestAlgorithm, String receiptDeliveryOption, MuleEvent muleEvent) throws AS2ConnectorException {
        this.setB2BProvider();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setAs2From(as2From);
        clientConfig.setAs2To(as2To);
        clientConfig.setSubject(subject);
        clientConfig.setContentType(contentType);
        clientConfig.setSign(sign);
        clientConfig.setEncrypt(encrypt);
        clientConfig.setRequireReceiptForUnsupportedSignatureFormat(requireReceiptForUnsupportedSignatureFormat);
        clientConfig.setRequireReceiptForUnsupportedDigestAlgorithm(requireReceiptForUnsupportedDigestAlgorithm);
        clientConfig.setDigestAlgorithm(digestAlgorithm);
        clientConfig.setFallbackDigestAlgorithm(fallbackDigestAlgorithm);
        clientConfig.setKeyStorePath(keyStorePath);
        clientConfig.setKeyStorePassword(keyStorePassword);
        clientConfig.setRequestReceipt(requestReceipt);
        clientConfig.setFilename(filename);
        clientConfig.setReceiptDeliveryOption(receiptDeliveryOption);
        clientConfig.setReceiptTimeout(receiptTimeout);
        clientConfig.setContentTransferEncoding(contentTransferEncoding);
        clientConfig.setAsyncReceiptTlsCertificateKeyStoreEntryAlias(asyncReceiptTlsCertificateKeyStoreEntryAlias);
        clientConfig.setReceiptVerificationCertificateKeyStoreEntryAlias(receiptVerificationCertificateKeyStoreEntryAlias);
        clientConfig.setCompress(compress);
        clientConfig.setMessageId(messageId);
        clientConfig.setSuppressCmsAlgorithmProtectionAttribute(suppressCmsAlgorithmProtectionAttribute);
        if (this.as2ClientFactory == null) {
            AS2Connector aS2Connector = this;
            synchronized (aS2Connector) {
                this.as2ClientFactory = new ClientFacadeFactory(clientConfig, this.muleContext, this.connectorContext, this.connectorConfig.getHttpEndpointRef());
            }
        }
        ClientFacade client = this.as2ClientFactory.createClient(clientConfig);
        MuleEvent reply = client.send(muleEvent);
        try {
            client.close();
        }
        catch (IOException e) {
            throw new AS2ConnectorException(e);
        }
        return reply;
    }

    public synchronized void onStop() throws AS2ConnectorException {
        if (this.as2Server != null) {
            this.as2Server.stop();
        }
    }

    public void setB2BProvider() throws AS2ConnectorException {
        if (this.connectorConfig.getUseB2BProvider().booleanValue()) {
            B2BProvider b2bProvider;
            try {
                b2bProvider = (B2BProvider)this.muleContext.getRegistry().lookupObject(B2BProvider.class);
            }
            catch (RegistrationException e) {
                throw new AS2ConnectorException(e);
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) {
                    b2bProvider = null;
                }
                throw new AS2ConnectorException(e);
            }
            if (b2bProvider != null) {
                ((PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig()).setB2BProvider(b2bProvider);
            } else {
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"No B2B Provider found. Make sure Partner Manager Connector is set up."));
            }
        }
    }

    @PostConstruct
    public void onPostConstruct() throws AS2ConnectorException {
        this.connectorContext.setAs2Service((AS2Service)new AS2ServiceImpl());
        ObjectStore objectStore = this.muleContext.getObjectStoreManager().getObjectStore("as2ConnectorObjectStore", false, 0, 600000, 60000);
        this.connectorContext.setObjectStore((ObjectStore<Receipt>)objectStore);
        this.connectorContext.setConnectorConfig(this.connectorConfig);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public ConnectorContext getConnectorContext() {
        return this.connectorContext;
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(ConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }
}

