/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2;

import com.modus.mule.modules.as2.common.AS2ConnectorException;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.shade.client.config.RequestConfig;
import org.apache.http.shade.impl.client.CloseableHttpClient;
import org.apache.http.shade.impl.client.HttpClientBuilder;
import org.apache.http.shade.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.shade.impl.nio.client.HttpAsyncClientBuilder;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class GlobalContext
implements Closeable {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static GlobalContext globalContext = null;
    private CloseableHttpAsyncClient httpAsyncClient;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper = new ObjectMapper();

    public static GlobalContext getInstance() throws AS2ConnectorException {
        if (globalContext == null) {
            globalContext = new GlobalContext();
        }
        return globalContext;
    }

    private GlobalContext() throws AS2ConnectorException {
        this.objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        this.httpAsyncClient = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        this.httpAsyncClient.start();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public CloseableHttpAsyncClient getHttpAsyncClient() {
        return this.httpAsyncClient;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void close() throws IOException {
        this.httpAsyncClient.close();
        this.httpClient.close();
    }
}

