/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client.strategy;

import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.Receipt;
import com.modus.mule.modules.as2.client.strategy.ClientStrategy;
import com.modus.mule.modules.as2.common.Misc;
import java.io.IOException;
import java.io.Serializable;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;

public class DefaultClientStrategy
extends ClientStrategy {
    public DefaultClientStrategy(ClientConfig clientConfig, ConnectorContext connectorContext, OutboundEndpoint outboundEndpoint) {
        super(clientConfig, connectorContext, outboundEndpoint);
    }

    @Override
    protected Receipt getReceipt(String as2MessageId) throws Exception {
        Receipt receipt;
        if (this.connectorContext.getObjectStore().contains((Serializable)((Object)as2MessageId)) && (receipt = (Receipt)this.connectorContext.getObjectStore().retrieve((Serializable)((Object)as2MessageId))) != null && !receipt.isMdnExpected()) {
            return receipt;
        }
        return null;
    }

    @Override
    public void onReceiveReceiptError(Message as2Message, MuleEvent requestMuleEvent, Exception exception, MuleEvent receiptMuleEvent) throws Exception {
    }

    @Override
    public void onSend(Message as2Request, MuleEvent requestMuleEvent) throws Exception {
    }

    @Override
    public void onReceiveAsyncReceipt(MessageMDN messageMDN, MuleEvent receiptMuleEvent, MuleEvent requestMuleEvent) throws Exception {
        Receipt receipt = new Receipt();
        receipt.setMdnContent(receiptMuleEvent.getMessage().getPayloadAsBytes());
        receipt.setMdnContentType(receiptMuleEvent.getMessage().getInboundProperty("Content-Type").toString());
        receipt.isMdnExpected(false);
        if (receiptMuleEvent.getMessage().getInboundProperty("AS2-From") != null) {
            receipt.setAs2From(receiptMuleEvent.getMessage().getInboundProperty("AS2-From").toString());
        }
        this.connectorContext.getObjectStore().store((Serializable)((Object)Misc.stripAngleBrackets(messageMDN.getHeader("Original-Message-ID"))), (Serializable)receipt);
    }

    @Override
    public void onSuccessfulReceipt(Message as2Request, MuleEvent receiptMuleEvent, MuleEvent requestMuleEvent) throws Exception {
    }

    @Override
    public void onClose() throws IOException {
    }
}

