/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.config;

import com.modus.mule.modules.as2.sources.ReceiveMessageSource;
import org.mule.config.MuleManifest;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ReceiveDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(ReceiveDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)ReceiveMessageSource.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Source [receive] within the connector [as2] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Source [receive] within the connector [as2] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"receive");
        builder.setScope("prototype");
        if (!this.hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [receive] within the connector [as2] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        this.parseConfigRef(element, builder);
        this.parseProperty(builder, element, "receiptSubject", "receiptSubject");
        this.parseProperty(builder, element, "requireSenderCompress", "requireSenderCompress");
        this.parseProperty(builder, element, "requireSenderAs2From", "requireSenderAs2From");
        this.parseProperty(builder, element, "requireSenderAs2To", "requireSenderAs2To");
        this.parseProperty(builder, element, "keyStorePath", "keyStorePath");
        this.parseProperty(builder, element, "keyStorePassword", "keyStorePassword");
        this.parseProperty(builder, element, "suppressCmsAlgorithmProtectionAttribute", "suppressCmsAlgorithmProtectionAttribute");
        this.parseProperty(builder, element, "requireSenderSigns", "requireSenderSigns");
        this.parseProperty(builder, element, "requireSenderEncrypts", "requireSenderEncrypts");
        this.parseProperty(builder, element, "preferredDigestAlgorithm", "preferredDigestAlgorithm");
        this.parseProperty(builder, element, "invokeFlowBeforeSendReceipt", "invokeFlowBeforeSendReceipt");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachSourceDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

