/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.client.protocol;

import java.io.IOException;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.HttpEntityEnclosingRequest;
import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpRequestInterceptor;
import org.apache.http.shade.HttpVersion;
import org.apache.http.shade.ProtocolVersion;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.client.config.RequestConfig;
import org.apache.http.shade.client.protocol.HttpClientContext;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

