/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.client.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.http.shade.Header;
import org.apache.http.shade.HeaderElement;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.HttpResponseInterceptor;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.client.config.RequestConfig;
import org.apache.http.shade.client.entity.DecompressingEntity;
import org.apache.http.shade.client.entity.DeflateInputStream;
import org.apache.http.shade.client.entity.InputStreamFactory;
import org.apache.http.shade.client.protocol.HttpClientContext;
import org.apache.http.shade.config.Lookup;
import org.apache.http.shade.config.RegistryBuilder;
import org.apache.http.shade.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private static final InputStreamFactory GZIP = new InputStreamFactory(){

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    };
    private static final InputStreamFactory DEFLATE = new InputStreamFactory(){

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new DeflateInputStream(instream);
        }
    };
    private final Lookup<InputStreamFactory> decoderRegistry;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIP).register("x-gzip", GZIP).register("deflate", DEFLATE).build();
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isDecompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname)) continue;
                throw new HttpException("Unsupported Content-Coding: " + codec.getName());
            }
        }
    }
}

